/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Properties
extends java.util.Properties {
    @Override
    public String getProperty(String key) {
        String value = super.getProperty(key);
        if (null != value && value.contains("${")) {
            try {
                value = this.evaluateStringExpression(value);
            }
            catch (IOException ex) {
                Logger.getLogger(Properties.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.setProperty(key, value);
        }
        return value;
    }

    public List<String> getKeys(String filter) {
        String regexpPattern = filter.replaceAll("[^\\*\\?]+", "\\\\Q$0\\\\E");
        regexpPattern = regexpPattern.replaceAll("\\*", ".*");
        regexpPattern = regexpPattern.replaceAll("\\?", ".");
        ArrayList<String> filteredKeys = new ArrayList<String>();
        Enumeration<Object> keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = String.valueOf(keys.nextElement());
            if (!key.matches(regexpPattern)) continue;
            filteredKeys.add(key);
        }
        return filteredKeys;
    }

    private String evaluateStringExpression(String expr) throws IOException {
        int i1;
        if (expr.trim().equals("${null}")) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        int i0 = 0;
        while ((i1 = expr.indexOf("${", i0)) != -1) {
            if (i1 == 0 || i1 > 0 && expr.charAt(i1 - 1) != '\\') {
                int i2 = expr.indexOf("}", i1);
                if (i2 != -1 && i2 > i1 + 2) {
                    String k = expr.substring(i1 + 2, i2);
                    String v = this.evaluateStringExpression(k);
                    value.append(expr.substring(i0, i1));
                    if (v == null) {
                        String msg = String.format("no value for \"%s\" in \"%s\"", k, expr);
                        throw new IOException(msg);
                    }
                    value.append(v);
                    i0 = i2 + 1;
                    continue;
                }
                String msg = String.format("no closing brace in \"%s\"", expr);
                throw new IOException(msg);
            }
            value.append(expr.substring(i0, i1 - 1));
            value.append("${");
            i0 = i1 + 2;
        }
        value.append(expr.substring(i0));
        return value.toString();
    }
}

