% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-osm-basemap.R
\name{plot_osm_basemap}
\alias{plot_osm_basemap}
\title{plot_osm_basemap}
\usage{
plot_osm_basemap(bbox, structures, bg = "gray20")
}
\arguments{
\item{bbox}{bounding box (Latitude-longitude range) to be plotted.  A 2-by-2
matrix of 4 elements with columns of min and max values, and rows of x and y
values.}

\item{structures}{Data frame returned by osm_structures() used here to
specify background colour of plot; if missing, the colour is specified by
'bg'}

\item{bg}{Background colour of map (default = 'gray20' only if structs not
given)}
}
\value{
ggplot object containing base map
}
\description{
Generates a base OSM plot ready for polygon, line, and point objects to be
overlain with add_osm_objects().
}
\examples{
bbox <- get_bbox (c (-0.13, 51.5, -0.11, 51.52))
map <- plot_osm_basemap (bbox=bbox, bg='gray20')
map <- add_osm_objects (map, london$dat_BNR, col='gray40') 
print (map)
}
\seealso{
\code{\link{add_osm_objects}}, \code{\link{make_osm_map}}.
}

