% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracer-provider-noop.R
\name{otel_tracer}
\alias{otel_tracer}
\title{OpenTelemetry Tracer Object}
\value{
Not applicable.
}
\description{
\link{otel_tracer_provider} -> \link{otel_tracer} -> \link{otel_span} -> \link{otel_span_context}
}
\details{
Usually you do not need to deal with otel_tracer objects directly.
\code{\link[=start_local_active_span]{start_local_active_span()}} (and \code{\link[=start_span]{start_span()}}) automatically
sets up the tracer and uses it to create spans.

A tracer object is created by calling the \code{get_tracer()} method of an
\link{otel_tracer_provider}.

You can use the \code{start_span()} method of the  tracer object to create a
span.

Typically there is a separate tracer object for each instrumented R
package.
}
\section{Methods}{
\subsection{\code{tracer$start_span()}}{

Creates and starts a new span.

It does not activate the new span.

It is equivalent to the \code{\link[=start_span]{start_span()}} function.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tracer_start_span(
  name = NULL,
  attributes = NULL,
  links = NULL,
  options = NULL
)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: Name of the span. If not specified it will be \code{"<NA>"}.
\item \code{attributes}: Span attributes. OpenTelemetry supports the following
R types as attributes: `character, logical, double, integer.
You may use \code{\link[=as_attributes]{as_attributes()}} to convert other R types to
OpenTelemetry attributes.
\item \code{links}: A named list of links to other spans. Every link must be an
OpenTelemetry span (\link{otel_span}) object, or a list with a span
object as the first element and named span attributes as the rest.
\item \code{options}:   A named list of span options. May include: \itemize{
\item \code{start_system_time}: Start time in system time.
\item \code{start_steady_time}: Start time using a steady clock.
\item \code{parent}: A parent span or span context. If it is \code{NA}, then the
span has no parent and it will be a root span. If it is \code{NULL}, then
the current context is used, i.e. the active span, if any.
\item \code{kind}: Span kind, one of \link{span_kinds}:
"internal", "server", "client", "producer", "consumer".}
}
}

\subsection{Value}{

A new \link{otel_span} object.
}

}

\subsection{\code{tracer$is_enabled()}}{

Whether the tracer is active and recording traces.

This is equivalent to the \code{\link[=is_tracing_enabled]{is_tracing_enabled()}} function.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tracer$is_enabled()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Logical scalar.
}

}

\subsection{\code{tracer$flush()}}{

Flush the tracer provider: force any buffered spans to flush. Tracer
providers might not implement this method.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tracer$flush()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Nothing.
}

}
}

\examples{
tp <- get_default_tracer_provider()
trc <- tp$get_tracer()
trc$is_enabled()
}
\seealso{
Other low level trace API: 
\code{\link{get_default_tracer_provider}()},
\code{\link{get_tracer}()},
\code{\link{otel_span}},
\code{\link{otel_span_context}},
\code{\link{otel_tracer_provider}},
\code{\link{tracer_provider_noop}}
}
\concept{low level trace API}
