% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WMSClient.R
\docType{class}
\name{WMSClient}
\alias{WMSClient}
\title{WMSClient}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Web Map Service.
}
\description{
WMSClient
}
\section{Methods}{

\describe{
 \item{\code{new(url, serviceVersion, user, pwd, logger)}}{
   This method is used to instantiate a WMSClient with the \code{url} of the
   OGC service. Authentication is supported using basic auth (using \code{user}/\code{pwd} arguments), 
   bearer token (using \code{token} argument), or custom (using \code{headers} argument). By default, the \code{logger}
   argument will be set to \code{NULL} (no logger). This argument accepts two possible 
   values: \code{INFO}: to print only \pkg{ows4R} logs, \code{DEBUG}: to print more verbose logs
 }
 \item{\code{getCapabilities()}}{
   Get service capabilities. Inherited from OWS Client
 }
 \item{\code{reloadCapabilities()}}{
   Reload service capabilities
 }
}
}

\examples{
\donttest{
   #example based on a WMS endpoint responding at http://localhost:8080/geoserver/wms
   wms <- WMSClient$new("http://localhost:8080/geoserver/wms", serviceVersion = "1.1.1")
   
   #get capabilities
   caps <- wms$getCapabilities()
   
   #get feature info
   
   #Advanced examples at https://github.com/eblondel/ows4R/wiki#wms
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GetFeatureInfo}
\keyword{Map}
\keyword{OGC}
\keyword{WMS}
