% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_output.R
\name{get_tidy_oxcalresult}
\alias{get_tidy_oxcalresult}
\alias{get_tidy_oxcalresult.default}
\alias{get_tidy_oxcalresult.oxcAARCalibratedDate}
\alias{get_tidy_oxcalresult.oxcAARCalibratedDatesList}
\title{tidy output}
\usage{
get_tidy_oxcalresult(x)

\method{get_tidy_oxcalresult}{default}(x)

\method{get_tidy_oxcalresult}{oxcAARCalibratedDate}(x)

\method{get_tidy_oxcalresult}{oxcAARCalibratedDatesList}(x)
}
\arguments{
\item{x}{an object of class oxcAARCalibratedDate or oxcAARCalibratedDatesList}
}
\value{
a data.frame (with list columns)
}
\description{
Transforms oxcAAR output to a tidy data format.
See \url{http://vita.had.co.nz/papers/tidy-data.html} and
\url{https://CRAN.R-project.org/package=broom}
}
\examples{
\dontrun{
x <- oxcalCalibrate(c(5000, 4500, 3000), c(20, 50, 60))
get_tidy_oxcalresult(x)
y <- oxcalCalibrate(5000, 20)[[1]]
get_tidy_oxcalresult(y)
}

}
