% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_and_interpolate.R
\name{simulate_and_interpolate}
\alias{simulate_and_interpolate}
\title{Simulate and interpolate}
\usage{
simulate_and_interpolate(object, nsim = 1, simupoints = NULL,
  interpolatepoints = NULL, nugget.sim = 0, type = "UK")
}
\arguments{
\item{object}{km object}

\item{nsim}{numbero of simulations}

\item{simupoints}{simulations points, locations where the field was simulated}

\item{interpolatepoints}{points where posterior simulations are approximated}

\item{nugget.sim}{nugget to be added to simulations for numerical stability}

\item{type}{type of kriging model used for approximation (default Universal Kriging)}
}
\value{
A matrix \code{nsim*interpolatepoints} containing the approximate realizations.
}
\description{
Generates \code{nsims} approximate posterior field realizations
at \code{interpolatepoints}. The approximate realizations are computed by
simulating the field only at \code{simupoints} simulation points.
}
\examples{
### Simulate and interpolate for a 2d example
if (!requireNamespace("DiceKriging", quietly = TRUE)) {
stop("DiceKriging needed for this example to work. Please install it.",
     call. = FALSE)
}
if (!requireNamespace("DiceDesign", quietly = TRUE)) {
stop("DiceDesign needed for this example to work. Please install it.",
     call. = FALSE)
}
# Define the function
g=function(x){
  return(-DiceKriging::branin(x))
}
d=2
# Fit OK km model
design<-DiceDesign::maximinESE_LHS(design = DiceDesign::lhsDesign(n=50,
                                                                  dimension = 2,
                                                                  seed=42)$design)$design
colnames(design)<-c("x1","x2")
observations<-apply(X = design,MARGIN = 1,FUN = g)
kmModel<-DiceKriging::km(formula = ~1,design = design,response = observations,
                         covtype = "matern3_2",control=list(trace=FALSE))
# Get simulation points
# Here they are not optimized, you can use optim_dist_measure to find optimized points
simu_points <- matrix(runif(200),ncol=d)
# obtain nsims posterior realization at simu_points
nsims <- 1
nn_data<-expand.grid(seq(0,1,,50),seq(0,1,,50))
nn_data<-data.frame(nn_data)
colnames(nn_data)<-colnames(kmModel@X)
approx.simu <- simulate_and_interpolate(object=kmModel, nsim = 1, simupoints = simu_points,
                                        interpolatepoints = as.matrix(nn_data),
                                        nugget.sim = 0, type = "UK")
\donttest{
## Plot the approximate process realization
image(matrix(approx.simu[1,],ncol=50),
      col=grey.colors(20))
contour(matrix(approx.simu[1,],ncol=50),
        nlevels = 20,add=TRUE)

}
}
\references{
Azzimonti D. F., Bect J., Chevalier C. and Ginsbourger D. (2016). Quantifying uncertainties on excursion sets under a Gaussian random field prior. SIAM/ASA Journal on Uncertainty Quantification, 4(1):850–874.

Azzimonti, D. (2016). Contributions to Bayesian set estimation relying on random field priors. PhD thesis, University of Bern.
}
