#' Precipitation line plot
#'
#' Function for plotting (line) time-series of area averaged precipitation.
#'
#' @import ggplot2
#' @param x a csv generated by \code{\link{make_ts}}
#' @return ggplot object
#' @export

plot_line <- function(x){
  p00 <- ggplot(x, aes(x = date, y = value, color = name)) + 
    geom_line() +
    theme_bw() +
    labs(x = NULL, y = "[mm]", title = "Precipitation") +
    scale_x_date(breaks = seq(as.Date("1840/1/1"), as.Date("2050/1/1"), 
                              by = "10 year"), date_labels = "%Y") +
    theme(plot.title = element_text(size=24),
          axis.text = element_text(size = 20),
          axis.title = element_text(size = 24))
  return(p00)
}