% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pact.R
\name{pact.cv}
\alias{pact.cv}
\title{Cross-validation for pact}
\usage{
pact.cv(p, nfold)
}
\arguments{
\item{p}{An object of class 'pact'}

\item{nfold}{The number of folds (k) for the k-fold cross-validation. k equal to the sample size 
would mean a leave-one-out cross-validation}
}
\value{
A list with the following components

\item{PredScore}{The cross-validated scores for each subject (a vector)}

\item{Y}{The response variable used}

\item{Xf}{The dataframe of fixed prognostic covariates}

\item{Xv}{The dataframe of candidate predictive variables}

\item{Treatment}{The treatment assignment indicator used}

\item{nCovarf}{The number of variables in Xf}

\item{nCovarv}{The number of variables in Xv}

\item{family}{Type of the response variable}

\item{varSelect}{The variable selection method used}

\item{nsig, cvfolds.varSelect, which.lambda, penalty.scaling}{The variable selection parameters used}

\item{call}{The call that produced this output}
}
\description{
Predictive scores using k-fold cross-validation for the model developed in \code{pact.fit}
}
\details{
Obtain cross-validated predictive scores for the model developed in \code{pact.fit}.
In each fold of the cross-validation, a model is developed from the observations in the 
training set using the same variable selection parameters as that used for the model  
developed in \code{pact.fit}. The estimated coefficients of the regression model developed 
using training set are used to make predictions for the left out observations (test set). 
This is repeated for all the folds. Scores are thus obtained for all the subjects in the dataset. 
The function \code{\link{eval.pact.cv}} provides various evaluation options for the cross-validated 
scores.
}
\examples{
data(prostateCancer)
Y <- prostateCancer[,3:4]
Xf <- prostateCancer[,7:8]
Xv <- prostateCancer[,c(5:6,9)]
Treatment <- as.factor(prostateCancer[,2])
p <- pact.fit(Y=Y,Xf=Xf,Xv=Xv,Treatment=Treatment,family="cox",varSelect="lasso")
cv <- pact.cv(p, nfold=5)
}
\author{
Jyothi Subramanian and Richard Simon
\cr Maintainer: Jyothi Subramanian <\email{subramanianj01@gmail.com}>
}
\keyword{pact,}
\keyword{pact.cv}

