% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{plot_emission_intensity}
\alias{plot_emission_intensity}
\title{Create an emission intensity plot}
\usage{
plot_emission_intensity(data)
}
\arguments{
\item{data}{A data frame like the output of \code{prep_emission_intensity()}.}
}
\value{
An object of class "ggplot".
}
\description{
Create an emission intensity plot
}
\examples{
# plot with `qplot_emission_intensity()` parameters
data <- subset(sda, sector == "cement" & region == "global")
data <- prep_emission_intensity(data, span_5yr = TRUE, convert_label = to_title)

plot_emission_intensity(data)
}
\seealso{
Other plotting functions: 
\code{\link{plot_techmix}()},
\code{\link{plot_trajectory}()},
\code{\link{prep_emission_intensity}()},
\code{\link{prep_techmix}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_emission_intensity}()},
\code{\link{qplot_techmix}()},
\code{\link{qplot_trajectory}()},
\code{\link{recode_metric_techmix}()},
\code{\link{recode_metric_trajectory}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{scale_fill_r2dii_tech}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
