% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.analysis.R
\name{target_market_share}
\alias{target_market_share}
\title{Add targets for production, using the market share approach}
\usage{
target_market_share(
  data,
  abcd,
  scenario,
  region_isos = r2dii.data::region_isos,
  use_credit_limit = FALSE,
  by_company = FALSE,
  weight_production = TRUE,
  increasing_or_decreasing = r2dii.data::increasing_or_decreasing
)
}
\arguments{
\item{data}{A "data.frame" like the output of \code{r2dii.match::prioritize}.}

\item{abcd}{An asset level data frame like \link[r2dii.data:abcd_demo]{r2dii.data::abcd_demo}.}

\item{scenario}{A scenario data frame like \link[r2dii.data:scenario_demo_2020]{r2dii.data::scenario_demo_2020}.}

\item{region_isos}{A data frame like \link[r2dii.data:region_isos]{r2dii.data::region_isos} (default).}

\item{use_credit_limit}{Logical vector of length 1. \code{FALSE} defaults to using
the column \code{loan_size_outstanding}. Set to \code{TRUE} to use the column
\code{loan_size_credit_limit} instead.}

\item{by_company}{Logical vector of length 1. \code{FALSE} defaults to outputting
\code{production_value} at the portfolio-level. Set to \code{TRUE} to output
\code{production_value} at the company-level.}

\item{weight_production}{Logical vector of length 1. \code{TRUE} defaults to
outputting production, weighted by relative loan-size. Set to \code{FALSE} to
output the unweighted production values.}

\item{increasing_or_decreasing}{A data frame like
\link[r2dii.data:increasing_or_decreasing]{r2dii.data::increasing_or_decreasing}.}
}
\value{
A tibble including the summarized columns \code{metric}, \code{production},
\code{technology_share}, \code{percentage_of_initial_production_by_scope} and
\code{scope}. If \code{by_company = TRUE}, the output will also have the column
\code{name_abcd}.
}
\description{
This function calculates the portfolio-level production targets, as
calculated using the market share approach applied to each relevant climate
production forecast.
}
\section{Handling grouped data}{


This function ignores existing groups and outputs ungrouped data.

}

\examples{
\dontshow{if (rlang::is_installed("r2dii.data") && rlang::is_installed("r2dii.match", version = "0.1.0")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(r2dii.data)
library(r2dii.match)

loanbook <- head(loanbook_demo, 100)
abcd <- head(abcd_demo, 100)

matched <- loanbook \%>\%
  match_name(abcd) \%>\%
  prioritize()

# Calculate targets at portfolio level
matched \%>\%
  target_market_share(
    abcd = abcd,
    scenario = scenario_demo_2020,
    region_isos = region_isos_demo
    )

# Calculate targets at company level
matched \%>\%
  target_market_share(
  abcd = abcd,
  scenario = scenario_demo_2020,
  region_isos = region_isos_demo,
  by_company = TRUE
  )

matched \%>\%
  target_market_share(
    abcd = abcd,
    scenario = scenario_demo_2020,
    region_isos = region_isos_demo,
    # Calculate unweighted targets
    weight_production = FALSE
    )
\dontshow{\}) # examplesIf}
}
\seealso{
Other analysis functions: 
\code{\link{target_sda}()}
}
\concept{analysis functions}
