% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{bootSimpleComplex}
\alias{bootSimpleComplex}
\title{Bootstrap test to see if a complex model is significantly better than a simple
model.}
\usage{
bootSimpleComplex(y, simpleFit, complexFit, nboot = 99, minb = 7,
  ret.full.distribution = FALSE, parallel = FALSE, ...)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{simpleFit}{a \code{paleoTSfit} object, representing the model fit of a
simple model}

\item{complexFit}{a \code{paleoTSfit} object, representing the model fit of a
complex model}

\item{nboot}{number of replications for parametric bootstrapping}

\item{minb}{minimum number of populations within each segment}

\item{ret.full.distribution}{logical, indicating if the null distribution for
the likelihood ratio from the parametric bootstrap should be returned}

\item{parallel}{logical, if TRUE, the bootstrapping is done using parallel
computing}

\item{...}{further arguments, passed to optimization functions}
}
\value{
A list of the observed likelihood ratio statistic, \code{LRobs}, the
  P-value of the test, and the number of bootstrap replicates. If
  \code{ret.full.distribution = TRUE}, the null distribution of likelihood
  ratios generated by parametric bootstrapping is also returned.
}
\description{
Bootstrap test to see if a complex model is significantly better than a simple
model.
}
\details{
Simulations suggest that AICc can be overly liberal with complex
models with mode shifts or punctuations (Hunt et al., 2015). This function
implements an alternative of parametric boostrapping to compare the fit of a
simple model with a complex model. It proceeds in five steps: \enumerate{
\item Compute the observed gain in support from the simple to complex model
as the likelihood ratio, \eqn{LR_obs = -2(logL_simple - logL_complex) } \item
Simulate trait evolution under the specified simple model \code{nboot} times
\item Fit to each simulated sequence the specified simple and complex models
\item Measure the gain in support from simple to complex as the bootstrap
likelihood ratio for each simulated sequence \item Compute the P-value as the
percentile of the bootstrap distribution corresponding to the observed LR. }

Argument \code{simpleFit} should be a \code{paleoTS} object returned by the
function \code{fitSimple} or similar functions (e.g., \code{opt.joint.GRW,
opt.GRW}, etc.). Argument \code{complexFit} must be a \code{paleoTS} object
returned by \code{fitGpunc} or \code{fitModeShift}.

Calculations can be speeded up by setting \code{parallel = TRUE}, which uses
functions from the \code{\link{doParallel}} package to run the bootstrap
replicates in parallel, using one fewer than the number of detected cores.
}
\examples{
\dontrun{
x <- sim.Stasis.RW(ns = c(15, 15), omega = 0.5, ms = 1, order = "Stasis-RW")
ws <- fitSimple(x)
wc <- fitModeShift(x, order = "Stasis-RW", rw.model = "GRW")
bootSimpleComplex(x, ws, wc, nboot = 50, minb = 7)  # nboot too low for real analysis!
}
}
\references{
Hunt, G., M. J. Hopkins and S. Lidgard. 2015. Simple versus
complex models of trait evolution and stasis as a response to environmental
change. PNAS 112(16): 4885-4890.
}
\seealso{
\code{\link{sim.Stasis.RW}}, \code{\link{fitModeShift}}
}
