% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleModels.R
\name{opt.covTrack}
\alias{opt.covTrack}
\alias{opt.joint.covTrack}
\title{Fit a model in which a trait tracks a covariate}
\usage{
opt.covTrack(y, z, pool = TRUE, cl = list(fnscale = -1),
  meth = "L-BFGS-B", hess = FALSE)

opt.joint.covTrack(y, z, pool = TRUE, cl = list(fnscale = -1),
  meth = "L-BFGS-B", hess = FALSE)
}
\arguments{
\item{y}{a \code{paloeTS} object}

\item{z}{a vector of covariate values}

\item{pool}{if TRUE, sample variances are substituted with their pooled
estimate}

\item{cl}{optional control list, passed to \code{optim()}}

\item{meth}{optimization algorithm, passed to \code{optim()}}

\item{hess}{if TRUE, return standard errors of parameter estimates from the
hessian matrix}
}
\value{
a \code{paleoTSfit} object with the results of the model fitting
}
\description{
Fit a model in which a trait tracks a covariate
}
\details{
In this model, changes in a trait are linearly related to changes in
  a covariate with a slope of \code{b} and residual variance \code{evar}:
  \code{dx = b * dz + eps}, where \code{eps ~ N(0, evar)}.  This model was
  described, and applied to an example in which body size changes tracked
  changes in temperature, by Hunt et al. (2010). \cr

  For the AD version (\code{opt.covTrack}), a trait sequence of
  length \code{ns}, the covariate, \code{z}, can be of length \code{ns} - 1,
  interpreted as the vector of \emph{changes}, \code{dx}. If \code{z} is
  of length \code{ns}, differences are taken and these are used as the
  \code{dx}'s, with a warning issued. \cr

  The Joint version
  (\code{opt.joint.covTrack}), \code{z} should be of length \code{ns} and
  there is an additional parameter that is the intercept of the linear
  relationship between trait and covariate. See warning below about using the
  Joint version.
}
\section{Functions}{
\itemize{
\item \code{opt.joint.covTrack}: fits the covTrack model using the joint parameterization
}}

\section{Warning}{
 The Joint parameterization of this model can be fooled by
  temporal autocorrelation and, especially, trends in the trait and the
  covariate.  The latter is tested for, but the AD parameterization is
  generally safer for this model.
}

\examples{
set.seed(13)
z <- c(1, 2, 2, 4, 0, 8, 2, 3, 1, 9, 4, 3)
x <- sim.covTrack(ns = 12, z = z, b = 0.5, evar = 0.2)
w.urw <- opt.URW(x)
w.cov <- opt.covTrack(x, z = z)
compareModels(w.urw, w.cov)
}
\references{
Hunt, G, S. Wicaksono, J. E. Brown, and K. G. Macleod. 2010. Climate-driven
body size trends in the ostracod fauna of the deep Indian Ocean. \emph{Palaeontology}
53(6): 1255-1268.
}
\seealso{
\code{\link{fitSimple}}
}
