% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleModels.R
\name{mle.GRW}
\alias{mle.GRW}
\alias{mle.URW}
\alias{mle.Stasis}
\title{Analytical ML estimator for random walk and stasis models}
\usage{
mle.GRW(y)

mle.URW(y)

mle.Stasis(y)
}
\arguments{
\item{y}{a \code{paleoTS} object}
}
\value{
a vector of \code{mstep} and \code{vstep} for \code{mle.GRW},
\code{vstep} for \code{mle.URW}, and \code{theta} and \code{omega} for
\code{mle.Stasis}
}
\description{
Analytical ML estimator for random walk and stasis models
}
\section{Functions}{
\itemize{
\item \code{mle.URW()}: ML parameter estimates for URW model

\item \code{mle.Stasis()}: ML parameter estimates for Stasis model

}}
\note{
These analytical solutions assume even spacing of samples and equal
sampling variance in each, which will usually be violated in real data.
They are used here mostly to generate initial parameter estimates for
numerical optimization; they not likely to be called directly by the user.
}
\seealso{
\code{\link{fitSimple}}
}
