% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleModels.R
\name{fit3models}
\alias{fit3models}
\alias{fit4models}
\title{Fit a set of standard evolutionary models}
\usage{
fit3models(y, silent = FALSE, method = c("Joint", "AD", "SSM"), ...)

fit4models(y, silent = FALSE, method = c("Joint", "AD", "SSM"), ...)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{silent}{if TRUE, results are returned as a list and not printed}

\item{method}{"Joint", "AD", or "SSM"; see \code{\link{fitSimple}}}

\item{...}{other arguments passed to model fitting functions}
}
\value{
if silent = FALSE, a table of model fit statistics, also printed to the
screen.  if silent = TRUE, a list of the model fit statistics and model parameter values.
}
\description{
Fit a set of standard evolutionary models
}
\details{
Function \code{fit3models} fits the general (biased) random walk (GRW),
unbiased random walk (URW), and Stasis models.  In addition to these three,
\code{fit4models} also fits the model of Strict Stasis.
}
\section{Functions}{
\itemize{
\item \code{fit4models()}: add model of "Strict Stasis" to the three models

}}
\examples{
x <- sim.GRW(ns = 50, ms = 0.2)
fit4models(x)
}
\seealso{
\code{\link{fitSimple}}
}
