% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm.R
\name{opt.ssm.GRW}
\alias{opt.ssm.GRW}
\alias{opt.ssm.URW}
\alias{opt.ssm.Stasis}
\alias{opt.ssm.StrictStasis}
\alias{opt.ssm.OU}
\alias{opt.ssm.ACDC}
\alias{opt.ssm.covOU}
\alias{opt.ssm.URWshift}
\alias{opt.ssm.covOU_vshift}
\title{Fit evolutionary models using state-space models (SSM)}
\usage{
opt.ssm.GRW(y, pool = TRUE, cl = list(fnscale = -1), hess = FALSE)

opt.ssm.URW(y, pool = TRUE, cl = list(fnscale = -1), hess = FALSE)

opt.ssm.Stasis(y, pool = TRUE, cl = list(fnscale = -1), hess = FALSE)

opt.ssm.StrictStasis(y, pool = TRUE, cl = list(fnscale = -1), hess = FALSE)

opt.ssm.OU(y, pool = TRUE, cl = list(fnscale = -1), hess = FALSE)

opt.ssm.ACDC(y, pool = TRUE, cl = list(fnscale = -1), hess = FALSE)

opt.ssm.covOU(y, z, pool = TRUE, cl = list(fnscale = -1), hess = FALSE)

opt.ssm.URWshift(y, gg, pool = TRUE, cl = list(fnscale = -1), hess = FALSE)

opt.ssm.covOU_vshift(
  y,
  z,
  gg,
  pool = TRUE,
  cl = list(fnscale = -1),
  hess = FALSE
)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{pool}{if \code{TRUE}, sample variances are substituted with their pooled estimate}

\item{cl}{optional control list, passed to \code{optim()}}

\item{hess}{if \code{TRUE}, return standard errors of parameter estimates from the
hessian matrix}

\item{z}{a covariate vector, used only for the covOU models}

\item{gg}{a grouping vector, used only for the URWshift and covOU_vshift models}
}
\value{
a \code{paleoTSfit} object with the model fitting results
}
\description{
Fit evolutionary models using state-space models (SSM)
}
\details{
These functions use a state space model formulation to compute likelihoods and fit models.

Functions to fit the OU covariate tracking models (\code{covOU}, \code{covOU_vshift}) require a covariate argument, \code{z}.
At present, only the OU covariate tracking with a shift in the step variance (\code{covOU_vshift}) requires the grouping vector argument (\code{gg}).
}
\note{
For GRW, URW, Stasis, StrictStasis, ACDC and OU models, it will likely be easier to use the convenience function \code{fitSimple} with argument \code{method = "SSM"}.\cr
The grouping vector, \code{gg}, is a vector of length equal to the number of samples. It has one element for each sample and takes
integer value from 1 to the number of sample groups separated by shiftpoints. See the example below.
}
\examples{
y <- sim.GRW(ns = 30, vs = 2)
w1 <- opt.ssm.URW(y)
gg <- rep(1:2, each = 15) # shift occurs immediately after sample 15
w2 <- opt.ssm.URWshift(y, gg = gg) # test model in which the step variance shifts
compareModels(w1, w2)
}
\seealso{
\code{\link{fitSimple}}, \code{\link{opt.joint.GRW}}
}
