% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_geographic_functions.R
\name{pbdb_map}
\alias{pbdb_map}
\title{Map the fossil records}
\usage{
pbdb_map(
  data,
  col_int = "white",
  pch = 19,
  col_ocean = "black",
  main = NULL,
  col_point = c("light blue", "blue"),
  do_plot = TRUE,
  ...
)
}
\arguments{
\item{data}{Input data frame. This data frame is the output of the
\code{\link[=pbdb_occurrences]{pbdb_occurrences()}} function using the argument \code{show = "coords"}. See also Details and Examples.}

\item{col_int}{The colour of the mainland.}

\item{pch}{See \code{\link[=par]{par()}}.}

\item{col_ocean}{The colour of the ocean.}

\item{main}{Title of the map. See \code{\link[=par]{par()}}.}

\item{col_point}{Two or more colours that are used to generate the
colour gradient showing the number of occurrences per coordinate
in the map.}

\item{do_plot}{Logical. If \code{TRUE}, the function produces a plot in
addition to returning a data frame with the occurrence counts.}

\item{...}{Other parameters. See \code{\link[=par]{par()}} and \code{\link[=map]{map()}}.}
}
\value{
A data frame with the number of occurrences per
coordinate.
}
\description{
The function opens a new window with a map showing the distribution
of the fossil records as points. These points are coloured
according to the number of occurrences per cell.
}
\details{
The argument \code{show = "coords"} in the \code{\link[=pbdb_occurrences]{pbdb_occurrences()}}
function is required. We recommend the use of a cairo device
(\code{\link[=X11]{X11()}}) for better visualization of the maps. See Examples.
}
\examples{
\dontrun{
  data <- pbdb_occurrences(
    limit = "all", vocab = "pbdb", base_name = "Canis", show = "coords"
  )
  X11(width = 12, height = 8)
  pbdb_map(data)
  pbdb_map(data, pch = 1)
  pbdb_map(
    data,
    pch = 19,
    col_point = c("pink", "red"),
    col_ocean = "light blue",
    main = "Canis"
  )
}
}
\seealso{
See \code{\link[=pbdb_occurrences]{pbdb_occurrences()}}, \code{\link[=map]{map()}}, \code{\link[=par]{par()}} and \code{\link[=colors]{colors()}}
help pages.
}
