% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfCompositeLF.R
\name{plot.pfCompositeLF}
\alias{plot.pfCompositeLF}
\title{plot.pfCompositeLF}
\usage{
\method{plot}{pfCompositeLF}(x, type = "ci", add = "NULL", conf = c(0.05,
  0.95), palette = "jet", xlim = NULL, ylim = NULL, main = "Composite",
  text = FALSE, what = "locfit", ...)
}
\arguments{
\item{x}{A "pfCompositeLF" object.}

\item{type}{Character, type of plot among "ci", "prctile", "density"}

\item{add}{Character, add=NULL by default, add="sitenum" could be specified
to plot the sites number in eah bin along with the composite curve.}

\item{conf}{Numeric, confidence levels.}

\item{palette}{Character, color palette used with type=c("prctile",
"density") among "jet" and "BW".}

\item{xlim}{Numeric, x axis limits.}

\item{ylim}{Numeric, y axis limits.}

\item{main}{Character, title of the plot.}

\item{text}{Logical, text options.}

\item{what}{Character, indicates which transformed charcoal trend is used
for the plot (type="ci"), default "locfit" indicates that the trend is the
locfit applied to All binned data, use "mean" or "median" to plot the mean
or median of the locfit relplicates given by the bootstrap procedure.}

\item{\dots}{\dots{}}
}
\description{
Plot pfCompositeLF object
}
\examples{

ID=pfSiteSel(id_region=="WNA0",l12==1,long>=-160,long<=-140)

TR=pfTransform(ID, method=c("MinMax","Box-Cox","MinMax","Z-Score"),
               BasePeriod=c(200,2000),QuantType="INFL")

COMP1=pfCompositeLF(TR, tarAge=seq(-50,4000,10), hw=200, nboot=100)

plot(COMP1, type="density")

## Note: comparing confidence intervals based on 100 replicates is not recommended
# (100 is used to decrease analysis time)


}
\author{
O. Blarquez
}

