% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfCompositeLF.R
\name{contrib.pfCompositeLF}
\alias{contrib.pfCompositeLF}
\title{contrib.pfCompositeLF}
\usage{
\method{contrib}{pfCompositeLF}(x, ...)
}
\arguments{
\item{x}{A "pfCompositeLF" object.}

\item{\dots}{\dots{}}
}
\description{
Calculates the number of prebinned samples contributing to the composite curve. 
The number is calculated by counting the number on non null charcoal 
values at each tarAge from the prebinned charcoal series.
}
\examples{

ID=pfSiteSel(continent=="North America", l12==1, long>=-160 & long<=-140)

TR=pfTransform(ID, method=c("MinMax","Box-Cox","MinMax","Z-Score"),
               BasePeriod=c(200,2000),QuantType="INFL")

COMP1=pfCompositeLF(TR, tarAge=seq(-50,4000,10), hw=200, nboot=100)

a=contrib(COMP1)
plot(COMP1$BinCentres,a)


}
\author{
O. Blarquez
}
