% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split-data.R
\name{split_data}
\alias{split_data}
\title{Function to transform data without time-dependent covariates into piece-wise
exponential data format}
\usage{
split_data(formula, data, cut = NULL, max_time = NULL, ...)
}
\arguments{
\item{formula}{A two sided formula with a \code{\link[survival]{Surv}} object
on the left-hand-side and covariate specification on the right-hand-side (RHS).
The RHS can be an extended formula, which specifies how TDCs should be transformed
using specials \code{concurrent} and \code{cumulative}.}

\item{data}{Either an object inheriting from data frame or in case of
time-dependent covariates a list of data frames, where the first data frame
contains the time-to-event information and static covariates while the second
(and potentially further data frames) contain information on time-dependent
covariates and the times at which they have been observed.}

\item{cut}{Break points, used to partition the follow up into intervals.
If unspecified, all unique event times will be used.}

\item{max_time}{If \code{cut} is unspecified, this will be the last
possible event time. All event times after \code{max_time}
will be administratively censored at \code{max_time}.}

\item{...}{Further arguments passed to the \code{data.frame} method and
eventually to \code{\link[survival]{survSplit}}}
}
\description{
Function to transform data without time-dependent covariates into piece-wise
exponential data format
}
\examples{
data("veteran", package="survival")
head(veteran)
ped <- split_data(Surv(time, status)~trt + age, data=veteran,
   cut=c(0, 100, 400), id="id")
head(ped)
class(ped) # class ped (piece-wise exponential data)
}
\seealso{
\code{\link[survival]{survSplit}}
}
\keyword{internal}
