% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-bin.R
\name{pandoc_citeproc_bin}
\alias{pandoc_citeproc_bin}
\title{Get path to the pandoc-citeproc binary.}
\usage{
pandoc_citeproc_bin(version = "default")
}
\arguments{
\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
the path to \code{pandoc-citeproc} binary if it exists. Since Pandoc 2.11,
the citeproc filter has been included into Pandoc itself and is no more
shipped as a binary filter.
}
\description{
This function will return the path to \code{pandoc-citeproc} if available. It will
only work with \code{version} of Pandoc installed by this package.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Look into current active version
pandoc_citeproc_bin()
\dontshow{\}) # examplesIf}
\dontshow{if (pandoc::pandoc_is_installed("2.9.2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Look into a specific version
pandoc_citeproc_bin("2.9.2")
\dontshow{\}) # examplesIf}
}
