% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-convert.R
\name{pandoc_convert}
\alias{pandoc_convert}
\title{Run Pandoc to convert a document or a text}
\usage{
pandoc_convert(
  file = NULL,
  text = NULL,
  from = "markdown",
  to,
  output = NULL,
  standalone = FALSE,
  args = c(),
  version = "default"
)
}
\arguments{
\item{file, text}{One or the other should be provided}

\item{from}{Format to convert from. This must be one of the format supported
by Pandoc. Default will be \code{markdown}. This correspond to the \href{https://pandoc.org/MANUAL.html#option--from}{\code{--from/-f} CLI flag}}

\item{to}{Format to convert to. This must be one of the format supported by
Pandoc. This correspond to the \href{https://pandoc.org/MANUAL.html#option--to}{\code{--to/-t} CLI flag}.}

\item{output}{Pass a path to a file to write the result from Pandoc
conversion into a file. This corresponds to the \href{https://pandoc.org/MANUAL.html#option--output}{\code{--output/-o} flag}}

\item{standalone}{Should appropriate header and footer be included ?
This corresponds to \href{https://pandoc.org/MANUAL.html#option--standalone}{\code{--standalone/-s} CLI flag}}

\item{args}{Any other flag supported by Pandoc CLI. See
\url{https://pandoc.org/MANUAL.html#options}}

\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
\code{output} is provided, the absolute file path. If not, the output of
\code{pandoc} binary run.
}
\description{
Main usage of Pandoc is to convert some text from a format into another.
This function will do just that:
\itemize{
\item converting from a file or directly from text
\item writing to a file or directly to console
}
}
\examples{
\dontshow{if (pandoc::pandoc_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pandoc::pandoc_convert(text = "_This will be emphasize_", to = "latex")
\dontshow{\}) # examplesIf}
\dontshow{if (pandoc::pandoc_is_installed("2.11.4")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pandoc::pandoc_convert(text = "**This will be bold**", to = "html", version = "2.11.4")
\dontshow{\}) # examplesIf}
}
