% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfilter.R, R/pfilter_methods.R
\docType{class}
\name{pfilter}
\alias{pfilter}
\alias{pfilterd.ppomp-class}
\alias{pfilter,panelPomp-method}
\alias{logLik,pfilterd.ppomp-method}
\alias{unitLogLik,pfilterd.ppomp-method}
\title{Particle filtering for panel data}
\usage{
\S4method{pfilter}{panelPomp}(
  data,
  shared,
  specific,
  params,
  Np,
  verbose = getOption("verbose"),
  ...
)

\S4method{logLik}{pfilterd.ppomp}(object, ...)

\S4method{unitLogLik}{pfilterd.ppomp}(object, ...)
}
\arguments{
\item{data}{An object of class \code{panelPomp} or inheriting class
\code{panelPomp}.}

\item{shared, specific}{optional; these arguments depend on the type
of \code{object}.

If \code{object} is a \code{list} of \code{pomp}s, \code{shared} must be a
numeric vector specifying parameter values shared among panel units.
\code{specific} must be a \code{matrix} with parameter values that are
unit-specific with rows naming parameters and columns naming units (these
names must match those of \code{object}). If no values are specified and
\code{object} has parameter values, these are set to be all unit-specific.

If \code{object} is a \code{panelPomp} object, these arguments can still be
used as described above to modify the parameters of \code{object}.
Alternatively, the parameter configuration of \code{object} can be modified
providing only a character \code{shared} naming parameters of \code{object}
that should be shared (with values for parameters not originally shared
taken from the unit-specific parameters of the first panel unit of
\code{object}). \code{shared=NULL} sets all parameters as unit-specific.}

\item{params}{optional; a named numeric vector. In this case, the nature of
parameters is determined via a naming convention: names ending in
\dQuote{\code{[unit_name]}} are assumed to denote unit-specific parameters;
all other names specify shared parameters.}

\item{Np}{the number of particles to use.
This may be specified as a single positive integer, in which case the same number of particles will be used at each timestep.
Alternatively, if one wishes the number of particles to vary across timesteps, one may specify \code{Np} either as a vector of positive integers of length \preformatted{length(time(object,t0=TRUE))} or as a function taking a positive integer argument.
In the latter case, \code{Np(k)} must be a single positive integer, representing the number of particles to be used at the \code{k}-th timestep:
\code{Np(0)} is the number of particles to use going from \code{timezero(object)} to \code{time(object)[1]},
\code{Np(1)}, from \code{timezero(object)} to \code{time(object)[1]},
and so on,
while when \code{T=length(time(object))}, \code{Np(T)} is the number of particles to sample at the end of the time-series.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}

\item{...}{additional arguments, passed to the \code{pfilter} method of \pkg{pomp}.}

\item{object}{required; either (i) a \code{list} of \code{pomp} objects; or
(ii) an object of class \code{panelPomp} or inheriting class
\code{panelPomp}.

If \code{object} is a \code{list} of \code{pomp}s, the list must be named.
All these \code{pomp}s must either have no parameters or have the same
parameter names. (This is just a format requirement. \code{pomp} codes can
ignore any parameter that is irrelevant to any given panel unit.)

If \code{object} is a \code{panelPomp} object, the function allows modifying
the shared and unit-specific configuration of \code{object}.}
}
\value{
\code{pfilter()} returns an object of class \code{pfilterd.ppomp} that is also
a \code{panelPomp} object (with the additional filtering details).

When applied to an object of class \code{pfilterd.ppomp}, \code{logLik()}
returns a \code{numeric} value.

\unitLogLikReturn
}
\description{
Tools for applying particle filtering algorithms to panel data.
}
\section{Methods}{

\describe{
\item{logLik}{Extracts the estimated log likelihood for the entire panel.}
\item{unitLogLik}{Extracts the estimated log likelihood for each panel unit.}
}
}

\examples{
# filter, which generates log likelihoods
pfrw <- pfilter(panelRandomWalk(),Np=10)
class(pfrw) # "pfilterd.ppomp"
is(pfrw,"panelPomp") # TRUE
pfrw
# extract single log likelihood for the entire panel
logLik(pfrw)
# extract log likelihood for each panel unit
unitLogLik(pfrw)
}
\references{
\arulampalam2002

\breto2020
}
\seealso{
\pkg{pomp}'s pfilter at \link[pomp:pfilter]{pfilter}, \link{panel_loglik}

Other panelPomp workhorse functions: 
\code{\link{mif2}()},
\code{\link{panelPomp}},
\code{\link{panel_loglik}}
}
\author{
Carles \Breto
}
\concept{panelPomp workhorse functions}
