% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_raw.R
\name{clean_raw}
\alias{clean_raw}
\title{Pass a panelsummary::panelsummary_raw dataframe into kableExtra::kbl() with typical defaults}
\usage{
clean_raw(
  data.frame,
  alignment = NULL,
  colnames = NULL,
  format = NULL,
  caption = NULL
)
}
\arguments{
\item{data.frame}{The data.frame (or tibble) from panelsummary::panelsummary_raw() that has been manipulated.}

\item{alignment}{A character string. By default, it is set to left adjusting the first column, and centering the rest of the columns. For example, a model with three columns will have adjustment of "lcc".}

\item{colnames}{An optional vector of strings. The vector of strings should have the same length as the number columns of the table.
* `NULL` (the default): colnames are defaulted to a whitespace, followed by (1), (2), ....etc.}

\item{format}{A character string. Possible values are latex, html, pipe (Pandoc's pipe tables), simple (Pandoc's simple tables), and rst. The value of this argument will be automatically determined if the function is called within a knitr document. The format value can also be set in the global option knitr.table.format. If format is a function, it must return a character string.}

\item{caption}{A string. The table caption.}
}
\value{
A raw data frame that is ready for further manipulation.
}
\description{
`clean_raw` Passes a panelsummary::panelsummary_raw dataframe that has (or has not) been edited further into kableExtra::kbl() with default settings that look publication-ready. This includes changing the column names and fixing the alignment.
}
\examples{

## Cleaning a panelsummary_raw dataframe with clean_raw

ols_1 <- lm(mpg ~ hp + cyl, data = mtcars)

panelsummary_raw(ols_1, ols_1) |> clean_raw()




}
