% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateFMS.R
\name{calculateFMS}
\alias{calculateFMS}
\title{Calculate Factor Match Score for all initialized models.}
\usage{
calculateFMS(models)
}
\arguments{
\item{models}{Output of \code{\link[=parafac]{parafac()}} using output="all".}
}
\value{
Vector containing FMS scores of all comparisons
}
\description{
Calculate Factor Match Score for all initialized models.
}
\examples{
A = array(rnorm(108*2), c(108, 2))
B = array(rnorm(100*2), c(100, 2))
C = array(rnorm(10*2), c(10, 2))
X = reinflateTensor(A, B, C)
models = parafac(X, 2, initialization="random", nstart=10, maxit=2, output="all")
calculateFMS(models)
}
