% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeClusterSequential.R
\name{makeClusterSequential}
\alias{makeClusterSequential}
\alias{SEQ}
\title{Create a "parallel" cluster running sequentially in the current session}
\usage{
makeClusterSequential()
}
\description{
The created cluster has only one node.
}
\details{
Expression and function calls are evaluated in a local environment,
inheriting the global environment.
}
\section{Requirements}{

This function is only defined for R (>= 4.4.0).
}

\examples{
\dontshow{if (getRversion() >= "4.4.0") \{}
library(parallel)

cl <- makeClusterSequential()
print(cl)

y <- parLapply(cl, X = 1:3, fun = sqrt)
str(y)

pid <- Sys.getpid()
print(pid)
y <- clusterEvalQ(cl, Sys.getpid())
str(y)

abc <- 3.14
y <- clusterEvalQ(cl, { abc <- 42; abc })
str(y)
stopifnot(abc == 3.14)

\dontshow{\}}

}
