% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.psych.R
\name{model_parameters.principal}
\alias{model_parameters.principal}
\title{Format PCA/FA from the psych package}
\usage{
\method{model_parameters}{principal}(model, sort = FALSE,
  threshold = NULL, labels = NULL, ...)
}
\arguments{
\item{model}{PCA or FA created by the \code{psych::principal} or \code{psych::fa} functions.}

\item{sort}{Sort the loadings.}

\item{threshold}{A value between 0 and 1 indicates which (absolute) values from the loadings should be removed. Can also be "max", in which case it will only display the maximum loading per veriable (the most simple structure).}

\item{labels}{A character vector containing labels to be added to the loadings data. Usually, the question related to the item.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data.frame of loadings.
}
\description{
Format PCA/FA objects from the psych package (Revelle, 2016).
}
\details{
\itemize{
   \item \strong{Complexity} (Hoffman's, 1978; Pettersson and Turkheimer, 2010) represents the number of latent components needed to account for the observed variables. Whereas a perfect simple structure solution has a complexity of 1 in that each item would only load on one factor, a solution with evenly distributed items has a complexity greater than 1.
   \item \strong{Uniqueness} represents the variance that is 'unique' to the variable and not shared with other variables. It is equal to \code{1 – communality} (variance that is shared with other variables). A uniqueness of \code{0.20} suggests that 20\% or that variable's variance is not shared with other variables in the overall factor model. The greater 'uniqueness' the lower the relevance of the variable in the factor model.
}
}
\examples{
library(parameters)
library(psych)

\donttest{
# Principal Component Analysis (PCA) ---------
pca <- psych::principal(attitude)
model_parameters(pca)
}

pca <- psych::principal(attitude, nfactors = 3, rotate = "none")
model_parameters(pca, sort = TRUE, threshold = 0.2)

principal_components(attitude, n = 3, sort = TRUE, threshold = 0.2)
\donttest{
# Exploratory Factor Analysis (EFA) ---------
efa <- psych::fa(attitude, nfactors = 3)
model_parameters(efa, threshold = "max", sort = TRUE, labels = as.character(1:ncol(attitude)))
}

}
\references{
\itemize{
  \item Pettersson, E., \& Turkheimer, E. (2010). Item selection, evaluation, and simple structure in personality data. Journal of research in personality, 44(4), 407-420.
  \item Revelle, W. (2016). How To: Use the psych package for Factor Analysis and data reduction.
}
}
