% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_cplm.R, R/methods_glmmTMB.R,
%   R/methods_lme4.R, R/methods_mixor.R, R/methods_ordinal.R
\name{model_parameters.cpglmm}
\alias{model_parameters.cpglmm}
\alias{model_parameters.glmmTMB}
\alias{model_parameters.merMod}
\alias{model_parameters.mixor}
\alias{model_parameters.clmm}
\title{Parameters from Mixed Models}
\usage{
\method{model_parameters}{cpglmm}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  effects = "all",
  group_level = FALSE,
  exponentiate = FALSE,
  df_method = NULL,
  p_adjust = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{glmmTMB}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  effects = "all",
  component = "all",
  group_level = FALSE,
  standardize = NULL,
  exponentiate = FALSE,
  df_method = NULL,
  p_adjust = NULL,
  wb_component = TRUE,
  summary = FALSE,
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{merMod}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  df_method = "wald",
  iterations = 1000,
  standardize = NULL,
  effects = "all",
  group_level = FALSE,
  exponentiate = FALSE,
  robust = FALSE,
  p_adjust = NULL,
  wb_component = TRUE,
  summary = FALSE,
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{mixor}(
  model,
  ci = 0.95,
  effects = "all",
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  verbose = TRUE,
  ...
)

\method{model_parameters}{clmm}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  effects = "all",
  group_level = FALSE,
  exponentiate = FALSE,
  df_method = NULL,
  p_adjust = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A mixed model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{bootstrap}{Should estimates be based on bootstrapped model? If
\code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian
regressions} apply (see also
\code{\link[=bootstrap_parameters]{bootstrap_parameters()}}).}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{standardize}{The method used for standardizing the parameters. Can be
\code{"refit"}, \code{"posthoc"}, \code{"smart"}, \code{"basic"},
\code{"pseudo"} or \code{NULL} (default) for no standardization. See
'Details' in \code{\link[effectsize]{standardize_parameters}}.
\strong{Important:} Categorical predictors (i.e. factors) are \emph{never}
standardized by default, which may be a different behaviour compared to
other R packages or other software packages (like SPSS). If standardizing
categorical predictors is desired, either use \code{standardize="basic"}
to mimic behaviour of SPSS or packages such as \pkg{lm.beta}, or standardize
the data with \code{effectsize::standardize(force=TRUE)} before fitting
the model. Robust estimation (i.e. \code{robust=TRUE}) of standardized
parameters only works when \code{standardize="refit"}.}

\item{effects}{Should parameters for fixed effects (\code{"fixed"}), random
effects (\code{"random"}), or both (\code{"all"}) be returned? Only applies
to mixed models. May be abbreviated.}

\item{group_level}{Logical, for multilevel models (i.e. models with random
effects) and when \code{effects = "all"} or \code{effects = "random"},
include the parameters for each group level from random effects. If
\code{group_level = FALSE} (the default), only information on SD and COR
are shown.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
the coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log
or logit links. \strong{Note:} Delta-method standard errors are also
computed (by multiplying the standard errors by the transformed
coefficients). This is to mimic behaviour of other software packages, such
as Stata, but these standard errors poorly estimate uncertainty for the
transformed coefficient. The transformed confidence interval more clearly
captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients
from non-Gaussian families.}

\item{df_method}{Method for computing degrees of freedom for p values,
standard errors and confidence intervals (CI). May be \code{"wald"}
(default, see \code{\link{degrees_of_freedom}}), \code{"ml1"} (see
\code{\link{dof_ml1}}), \code{"betwithin"} (see
\code{\link{dof_betwithin}}), \code{"satterthwaite"} (see
\code{\link{dof_satterthwaite}}) or \code{"kenward"} (see
\code{\link{dof_kenward}}). The options \code{df_method = "boot"},
\code{df_method = "profile"} and \code{df_method = "uniroot"} only affect
confidence intervals; in this case, bootstrapped resp. profiled confidence
intervals are computed. \code{"uniroot"} only applies to models of class
\code{glmmTMB}. For models of class \code{lmerMod}, when
\code{df_method = "wald"}, residual degrees of freedom are returned.
Note that when \code{df_method} is not \code{"wald"}, robust standard
errors etc. cannot be computed.}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to
adjust p-values. See \code{\link[stats]{p.adjust}} for details. Further
possible adjustment methods are \code{"tukey"}, \code{"scheffe"},
\code{"sidak"} and \code{"none"} to explicitly disable adjustment for
\code{emmGrid} objects (from \pkg{emmeans}).}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"}, \code{"dispersion"} or \code{"all"}
(default). May be abbreviated.}

\item{wb_component}{Logical, if \code{TRUE} and models contains within- and
between-effects (see \code{\link{demean}}), the \code{Component} column
will indicate which variables belong to the within-effects,
between-effects, and cross-level interactions. By default, the
\code{Component} column indicates, which parameters belong to the
conditional or zero-inflated component of the model.}

\item{summary}{Logical, if \code{TRUE}, prints summary information about the
model (model formula, number of observations, residual standard deviation
and more).}

\item{parameters}{Character vector of length 1 with a regular expression pattern
that describes the parameters that should be returned from the data frame, or
a named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{parameters} is a character vector, every
parameter in the \emph{"Parameters"} column that matches the regular expression in
\code{parameters} will be selected from the returned data frame. Furthermore,
if \code{parameters} has more than one element, these will be merged into
a regular expression pattern like this: \code{"(one|two|three)"}. If
\code{parameters} is a named list of regular expression patterns, the
names of the list-element should equal the column name where selection
should be applied. This is useful for model objects where
\code{model_parameters()} returns multiple columns with parameter components,
like in \code{\link{model_parameters.lavaan}}.}

\item{robust}{Logical, if \code{TRUE}, robust standard errors are calculated
(if possible), and confidence intervals and p-values are based on these
robust standard errors. Additional arguments like \code{vcov_estimation} or
\code{vcov_type} are passed down to other methods, see
\code{\link[=standard_error_robust]{standard_error_robust()}} for details
and \href{https://easystats.github.io/parameters/articles/model_parameters_robust.html}{this vignette}
for working examples.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters from (linear) mixed models.
}
\note{
There is also a \href{https://easystats.github.io/see/articles/parameters.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
library(parameters)
if (require("lme4")) {
  data(mtcars)
  model <- lmer(mpg ~ wt + (1 | gear), data = mtcars)
  model_parameters(model)
}
\donttest{
if (require("glmmTMB")) {
  data(Salamanders)
  model <- glmmTMB(
    count ~ spp + mined + (1 | site),
    ziformula = ~mined,
    family = poisson(),
    data = Salamanders
  )
  model_parameters(model, effects = "all")
}

if (require("lme4")) {
  model <- lmer(mpg ~ wt + (1 | gear), data = mtcars)
  model_parameters(model, bootstrap = TRUE, iterations = 50)
}
}
}
\seealso{
\code{\link[insight:standardize_names]{standardize_names()}} to
  rename columns into a consistent, standardized naming scheme.
}
