% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_d_to_r.R
\name{d_to_r}
\alias{d_to_r}
\alias{r_to_d}
\alias{convert_d_to_r}
\alias{convert_r_to_d}
\title{Conversion between standardized difference d and correlation r}
\usage{
d_to_r(d, ...)

r_to_d(r, ...)

convert_d_to_r(d, ...)

convert_r_to_d(r, ...)
}
\arguments{
\item{d}{A standardized difference value (Cohen's d).}

\item{...}{Arguments passed to or from other methods.}

\item{r}{A correlation coefficient r.}
}
\value{
Converted index.
}
\description{
Enables a conversion between standardized difference (Cohen's d) and correlation r.
}
\examples{
d_to_r(d = 1.1547)
}
\references{
\itemize{
  \item Borenstein, Michael, et al. "Converting among effect sizes." Introduction to meta-analysis (2009): 45-49.
}
}
