% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.zeroinfl.R
\name{model_parameters.zeroinfl}
\alias{model_parameters.zeroinfl}
\title{Model Parameters for Zero-Inflated Models}
\usage{
\method{model_parameters}{zeroinfl}(model, ci = 0.95,
  standardize = "refit", standardize_robust = FALSE,
  bootstrap = FALSE, iterations = 1000, component = c("all",
  "conditional", "zi", "zero_inflated"), ...)
}
\arguments{
\item{model}{A model with zero-inflation component.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{standardize}{Add standardized parameters. Can be \code{FALSE} or a character indicating the standardization method (see \code{\link[=parameters_standardize]{parameters_standardize()}}), such as \code{"refit"}, \code{"2sd"}, \code{"smart"} or \code{"classic"}. The two former are based on model refitting using a standardized version of data. It is the most accurate, although computationally heavy (as it must re-fit a second model). The "smart" and "classic" are post-hoc methods, fast, but inaccurate (especially if the model includes interactions).}

\item{standardize_robust}{Robust standardization. See \code{\link[=parameters_standardize]{parameters_standardize}}.}

\item{bootstrap}{Should estimates be based on bootstrapped model? If \code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply (see also \code{\link[=parameters_bootstrap]{parameters_bootstrap()}}).}

\item{iterations}{The number of bootstrap replicates. This only apply in the case of bootstrapped frequentist models.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}

\item{...}{Arguments passed to or from other methods (e.g., to \code{\link[=standardize.lm]{standardize()}}).}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters of zero-inflated models.
}
\examples{
library(parameters)
library(pscl)

data("bioChemists")
model <- zeroinfl(art ~ fem + mar + kid5 + ment | kid5 + phd, data = bioChemists)
model_parameters(model)
}
\seealso{
\code{\link[=standardize_names]{standardize_names()}} to rename
  columns into a consistent, standardized naming scheme.
}
