% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_error.R
\name{standard_error}
\alias{standard_error}
\alias{se}
\alias{standard_error.factor}
\alias{standard_error.glmmTMB}
\alias{standard_error.MixMod}
\title{Extract standard errors}
\usage{
standard_error(model, ...)

se(model, ...)

\method{standard_error}{factor}(model, force = FALSE, verbose = TRUE,
  ...)

\method{standard_error}{glmmTMB}(model, component = c("all",
  "conditional", "zi", "zero_inflated"), ...)

\method{standard_error}{MixMod}(model, component = c("all",
  "conditional", "zi", "zero_inflated"), ...)
}
\arguments{
\item{model}{A model.}

\item{...}{Arguments passed to or from other methods.}

\item{force}{Logical, if \code{TRUE}, factors are converted to numerical
values to calculate the standard error, with the lowest level being the
value \code{1} (unless the factor has numeric levels, which are converted
to the corresponding numeric value). By default, \code{NA} is returned
for factors or character vectors.}

\item{verbose}{Toggle warnings on or off.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}
}
\value{
A data frame.
}
\description{
This function attempts to return standard errors of model parameters.
}
\examples{
model <- lm(Petal.Length ~ Sepal.Length * Species, data = iris)
standard_error(model)
}
