% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/root.R
\name{root}
\alias{root}
\alias{root-nodes}
\alias{root-ids}
\alias{pd_is_root}
\alias{pd_all_root_ids}
\alias{ascend_to_root}
\title{Root IDs}
\usage{
pd_is_root(id, pd, ignore.groups = TRUE, .check = TRUE)

pd_all_root_ids(pd, include.groups = TRUE)

ascend_to_root(id = pd$id, pd = get("pd", parent.frame()),
  ignore.groups = TRUE, .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{ignore.groups}{Should \link[=pd_is_grouping]{groupings} be ignored?}

\item{.check}{Perform checks for input validation?}

\item{include.groups}{Include groups as root nodes (T)
or descend into \href{is.grouped}{groups} for roots?}
}
\description{
Root IDs constitute the id of a stand alone expression.
That is one that is not contained inside of another call or expression.
The one exception to this is code blocks denoted by curly braces
that are not themselves part of another call or expression;
these we call code groups.
In definition, A root node is defined to be a node that either
has no parent or whose parent is a grouping node.
}
\details{
If \code{ignore.groups=TRUE} then groupings are ignored and root nodes within the
group are interpreted as roots, otherwise nodes within a group are not
interpreted as root.  Groupings are always interpreted as root if the
parent is 0 or if the parent is a group and also a root.
}
\section{Functions}{
\itemize{
\item \code{pd_is_root}: Test if a node is a root node

\item \code{pd_all_root_ids}: give all root ids in \code{pd}

\item \code{ascend_to_root}: ascend from id to root
}}

\examples{
# load example file and get_parse data
ex.file <- system.file("examples", "example.R", package="parsetools")
exprs <- parse(ex.file, keep.source = TRUE)
pd <- get_parse_data(exprs)

# There are 3 expressions so there should be three roots.
sum(pd_is_root(pd$id, pd))
roots <- pd_all_root_ids(pd)
}
\seealso{
see \code{\link{pd_is_grouping}} for details on what a grouping is.
}
