% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_tree.R
\name{rpart_train}
\alias{rpart_train}
\title{Decision trees via rpart}
\usage{
rpart_train(formula, data, weights = NULL, cp = 0.01, minsplit = 20,
  maxdepth = 30, ...)
}
\arguments{
\item{formula}{A model formula.}

\item{data}{A data frame.}

\item{weights}{Optional case weights.}

\item{cp}{A non-negative number for complexity parameter. Any split
that does not decrease the overall lack of fit by a factor of
\code{cp} is not attempted. For instance, with anova splitting,
this means that the overall R-squared must increase by \code{cp} at
each step. The main role of this parameter is to save computing
time by pruning off splits that are obviously not worthwhile.
Essentially,the user informs the program that any split which
does not improve the fit by \code{cp} will likely be pruned off by
cross-validation, and that hence the program need not pursue it.}

\item{minsplit}{An integer for the minimum number of observations
that must exist in a node in order for a split to be attempted.}

\item{maxdepth}{An integer for the maximum depth of any node
of the final tree, with the root node counted as depth 0.
Values greater than 30 \code{rpart} will give nonsense results on
32-bit machines. This function will truncate \code{maxdepth} to 30 in
those cases.}

\item{...}{Other arguments to pass to either \code{rpart} or \code{rpart.control}.}
}
\value{
A fitted rpart model.
}
\description{
\code{rpart_train} is a wrapper for \code{rpart()} tree-based models
where all of the model arguments are in the main function.
}
\keyword{internal}
