% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arguments.R
\name{set_args}
\alias{set_args}
\alias{set_mode}
\alias{set_mode.model_spec}
\title{Change elements of a model specification}
\usage{
set_args(object, ...)

set_mode(object, mode, ...)

\method{set_mode}{model_spec}(object, mode, quantile_levels = NULL, ...)
}
\arguments{
\item{object}{A \link[=model_spec]{model specification}.}

\item{...}{One or more named model arguments.}

\item{mode}{A character string for the model type (e.g. "classification" or
"regression")}

\item{quantile_levels}{A vector of values between zero and one (only for the
\code{"quantile regression"} mode); otherwise, it is \code{NULL}. The model uses these
values to appropriately train quantile regression models to make predictions
for these values (e.g., \code{quantile_levels = 0.5} is the median).}
}
\value{
An updated model object.
}
\description{
\code{set_args()} can be used to modify the arguments of a model specification while
\code{set_mode()} is used to change the model's mode.
}
\details{
\code{set_args()} will replace existing values of the arguments.
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
rand_forest()

rand_forest() |>
  set_args(mtry = 3, importance = TRUE) |>
  set_mode("regression")

linear_reg() |>
  set_mode("quantile regression", quantile_levels = c(0.2, 0.5, 0.8))
\dontshow{\}) # examplesIf}
}
