% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{sokalSneath2}
\alias{sokalSneath2}
\alias{sokalSneath2,Partition,Partition-method}
\alias{sokalSneath2,PairCoefficients,missing-method}
\title{Sokal & Sneath Index 2}
\usage{
sokalSneath2(p, q)

\S4method{sokalSneath2}{Partition,Partition}(p, q)

\S4method{sokalSneath2}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index 2 of Sokal and Sneath
\deqn{\frac{N_{11}}{N_{11} + 2(N_{10} + N_{01})}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
isTRUE(all.equal(sokalSneath2(new("Partition", c(0, 0, 0, 1, 1)), 
                              new("Partition", c(0, 0, 1, 1, 1))), 0.2))

}
\references{
\insertRef{Sokal1963}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
