% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ybp2date.R
\name{ybp2date}
\alias{ybp2date}
\alias{date2ybp}
\title{Convert years BP from pastclim to lubridate date, or vice versa}
\usage{
ybp2date(x)

date2ybp(x)
}
\arguments{
\item{x}{a time in years BP using the \code{pastclim} convention of
negative numbers indicating years into the past, or a \code{POSIXct} date object}
}
\value{
a \code{POSIXct} date object, or a vector
}
\description{
These functions convert between years BP as used by pastclim (negative
numbers going into
the past, positive into the future) and standard
\code{POSIXct} date objects.
}
\examples{
ybp2date(-10000)
ybp2date(0)
# back and forth
date2ybp(ybp2date(-10000))

}
