% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_functions.R
\name{hyperg_test}
\alias{hyperg_test}
\title{Hypergeometic Distribution-based Hypothesis Testing}
\usage{
hyperg_test(pw_genes, chosen_genes, all_genes)
}
\arguments{
\item{pw_genes}{vector of genes in the selected pathway}

\item{chosen_genes}{vector containing the set of input genes}

\item{all_genes}{vector of "all" genes (background)}
}
\value{
the p-value as determined using the hypergeometric distribution.
}
\description{
Hypergeometic Distribution-based Hypothesis Testing
}
\details{
To determine whether the `chosen genes` are enriched
(compared to a background pool of genes) in the `pw_genes`, the
hypergeometric distribution is assumed and the appropriate p value
(the value under the right tail) is calculated and returned.
}
\examples{
hyperg_test(letters[1:5], letters[2:5], letters)
hyperg_test(letters[1:5], letters[2:10], letters)
hyperg_test(letters[1:5], letters[2:13], letters)
}
