% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{ds_aggregate}
\alias{ds_aggregate}
\title{Execute an aggregate query}
\usage{
ds_aggregate(
  ds,
  subject_resource,
  aggregations,
  groupings = NULL,
  filters = NULL
)
}
\arguments{
\item{ds}{The DataSource object containing the data to be queried.}

\item{subject_resource}{A string representing the type of FHIR resource to aggregate data from.}

\item{aggregations}{A named list of FHIRPath expressions that calculate a summary value from each
grouping. The expressions must be singular.}

\item{groupings}{An optional named list of FHIRPath expressions that determine which groupings
the resources should be counted within.}

\item{filters}{An optional sequence of FHIRPath expressions that can be evaluated against each resource
in the data set to determine whether it is included within the result. The expression must evaluate to a
Boolean value. Multiple filters are combined using logical AND operation.}
}
\value{
A Spark DataFrame containing the aggregated data.
}
\description{
Executes an aggregate query over FHIR data. The query calculates summary values based on 
aggregations and groupings of FHIR resources.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pc <- pathling_connect()
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples('ndjson'))
data_source \%>\% ds_aggregate('Patient',
     aggregations = c(patientCount='count()', 'id.count()'),
     groupings = c('gender', givenName='name.given'),
     filters = c('birthDate > @1950-01-01')
)
pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/fhirpath-query#aggregate}{Pathling documentation - Aggregate}

Other FHIRPath queries: 
\code{\link{ds_extract}()}
}
\concept{FHIRPath queries}
