% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{interactionWithMissing}
\alias{interactionWithMissing}
\title{Get interaction variable between different variables.}
\usage{
interactionWithMissing(data, vars, varSep = " - ")
}
\arguments{
\item{data}{Data.frame with data.}

\item{vars}{Character vector with variable(s) of interest.}

\item{varSep}{String with separator to which the variable(s)
should be combined.}
}
\value{
Vector of length: \code{nrow(data)},
with interaction vector.
}
\description{
This ensures that missing values in one of the variable(s) don't propagate,
so the combined result will be: 'NA - a',
and that the levels of the combined vector
are sorted as the levels of the specified
variables (levels of the first variable varying first).
}
\author{
Laure Cougnaud
}
