% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createPhenotype.R
\name{createPhenotype}
\alias{createPhenotype}
\title{Plot color pattern prediction for specified PCA values}
\usage{
createPhenotype(
  PCAdata,
  PCApredict,
  IDlist,
  rasterList,
  colpalette = NULL,
  plotCartoon = FALSE,
  refShape = NULL,
  outline = NULL,
  lines = NULL,
  landList = NULL,
  adjustCoords = FALSE,
  cartoonID = NULL,
  normalized = TRUE,
  crop = c(0, 0, 0, 0),
  flipRaster = NULL,
  flipOutline = NULL,
  imageList = NULL,
  cartoonOrder = "above",
  lineOrder = "above",
  cartoonCol = "gray",
  cartoonFill = NULL,
  legendTitle = "Proportion",
  zlim = NULL
)
}
\arguments{
\item{PCAdata}{Output of PCA analysis. List item 3 of patPCA.}

\item{PCApredict}{A vector with the PCA values for which to predict the phenotype. This vector
only needs to include the values upto the last PCA axis to predict along, other values are
set to zero.}

\item{IDlist}{List of sample IDs.}

\item{rasterList}{rasterList used for PCA.}

\item{colpalette}{Vector of colors for color palette
(default = c("white","lightblue","blue","green", "yellow","red"))}

\item{plotCartoon}{Whether to plot a cartoon. This cartoon should be drawn on one of the samples
used in the analysis.}

\item{refShape}{This can be 'target' in case the reference shape is a single sample (for
registration analysis) or 'mean' if the images were transformed to a mean shape (only for
meanshape when using landmark transformation)}

\item{outline}{xy coordinates that define outline.}

\item{lines}{list of files with xy coordinates of line objects to be added to cartoon.}

\item{landList}{Landmark landmarkList.}

\item{adjustCoords}{Adjust landmark coordinates.}

\item{cartoonID}{ID of the sample for which the cartoon was drawn.}

\item{normalized}{Set this to true in case the summed rasters are already devided by the
sample number.}

\item{crop}{Vector c(xmin, xmax, ymin, ymax) that specifies the pixel coordinates to crop
the original image used in landmark or registration analysis.}

\item{flipRaster}{Whether to flip raster along xy axis (in case there is an inconsistency
between raster and outline coordinates).}

\item{flipOutline}{Whether to flip plot along x, y or xy axis.}

\item{imageList}{List of images should be given if one wants to flip the outline or adjust
landmark coordinates.}

\item{cartoonOrder}{Whether to plot the cartoon outline 'above' or 'under' the pattern raster
(default = 'above'). Set to 'under' for filled outlines.}

\item{lineOrder}{Whether to plot the cartoon lines 'above' or 'under' the pattern raster
(default = 'above').}

\item{cartoonCol}{Outline and line color for cartoon (deafault = 'gray').}

\item{cartoonFill}{Fill color for outline of cartoon (default = NULL).}

\item{legendTitle}{Title of the raster legend (default = 'Proportion').}

\item{zlim}{zlim values for predicted pattern.}
}
\description{
Plot color pattern prediction for specified PCA values
}
