% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_list_application_snapshots}
\alias{kinesisanalyticsv2_list_application_snapshots}
\title{Lists information about the current application snapshots}
\usage{
kinesisanalyticsv2_list_application_snapshots(ApplicationName, Limit,
  NextToken)
}
\arguments{
\item{ApplicationName}{[required] The name of an existing application.}

\item{Limit}{The maximum number of application snapshots to list.}

\item{NextToken}{Use this parameter if you receive a \code{NextToken} response in a previous
request that indicates that there is more output available. Set it to
the value of the previous call's \code{NextToken} response to indicate where
the output should continue from.}
}
\value{
A list with the following syntax:\preformatted{list(
  SnapshotSummaries = list(
    list(
      SnapshotName = "string",
      SnapshotStatus = "CREATING"|"READY"|"DELETING"|"FAILED",
      ApplicationVersionId = 123,
      SnapshotCreationTimestamp = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists information about the current application snapshots.
}
\section{Request syntax}{
\preformatted{svc$list_application_snapshots(
  ApplicationName = "string",
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
