% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_delete_expression}
\alias{cloudsearch_delete_expression}
\title{Removes an Expression from the search domain}
\usage{
cloudsearch_delete_expression(DomainName, ExpressionName)
}
\arguments{
\item{DomainName}{[required]}

\item{ExpressionName}{[required] The name of the \code{Expression} to delete.}
}
\value{
A list with the following syntax:\preformatted{list(
  Expression = list(
    Options = list(
      ExpressionName = "string",
      ExpressionValue = "string"
    ),
    Status = list(
      CreationDate = as.POSIXct(
        "2015-01-01"
      ),
      UpdateDate = as.POSIXct(
        "2015-01-01"
      ),
      UpdateVersion = 123,
      State = "RequiresIndexDocuments"|"Processing"|"Active"|"FailedToValidate",
      PendingDeletion = TRUE|FALSE
    )
  )
)
}
}
\description{
Removes an \code{Expression} from the search domain. For more information,
see \href{https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html}{Configuring Expressions}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_expression(
  DomainName = "string",
  ExpressionName = "string"
)
}
}

\keyword{internal}
