% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_classifier}
\alias{glue_update_classifier}
\title{Modifies an existing classifier (a GrokClassifier, an XMLClassifier, a
JsonClassifier, or a CsvClassifier, depending on which field is present)}
\usage{
glue_update_classifier(GrokClassifier, XMLClassifier, JsonClassifier,
  CsvClassifier)
}
\arguments{
\item{GrokClassifier}{A \code{GrokClassifier} object with updated fields.}

\item{XMLClassifier}{An \code{XMLClassifier} object with updated fields.}

\item{JsonClassifier}{A \code{JsonClassifier} object with updated fields.}

\item{CsvClassifier}{A \code{CsvClassifier} object with updated fields.}
}
\value{
An empty list.
}
\description{
Modifies an existing classifier (a \code{GrokClassifier}, an \code{XMLClassifier},
a \code{JsonClassifier}, or a \code{CsvClassifier}, depending on which field is
present).
}
\section{Request syntax}{
\preformatted{svc$update_classifier(
  GrokClassifier = list(
    Name = "string",
    Classification = "string",
    GrokPattern = "string",
    CustomPatterns = "string"
  ),
  XMLClassifier = list(
    Name = "string",
    Classification = "string",
    RowTag = "string"
  ),
  JsonClassifier = list(
    Name = "string",
    JsonPath = "string"
  ),
  CsvClassifier = list(
    Name = "string",
    Delimiter = "string",
    QuoteSymbol = "string",
    ContainsHeader = "UNKNOWN"|"PRESENT"|"ABSENT",
    Header = list(
      "string"
    ),
    DisableValueTrimming = TRUE|FALSE,
    AllowSingleColumn = TRUE|FALSE
  )
)
}
}

\keyword{internal}
