% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_column_statistics_for_table}
\alias{glue_update_column_statistics_for_table}
\title{Creates or updates table statistics of columns}
\usage{
glue_update_column_statistics_for_table(CatalogId, DatabaseName,
  TableName, ColumnStatisticsList)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the partitions in question reside. If
none is supplied, the AWS account ID is used by default.}

\item{DatabaseName}{[required] The name of the catalog database where the partitions reside.}

\item{TableName}{[required] The name of the partitions' table.}

\item{ColumnStatisticsList}{[required] A list of the column statistics.}
}
\value{
A list with the following syntax:\preformatted{list(
  Errors = list(
    list(
      ColumnStatistics = list(
        ColumnName = "string",
        ColumnType = "string",
        AnalyzedTime = as.POSIXct(
          "2015-01-01"
        ),
        StatisticsData = list(
          Type = "BOOLEAN"|"DATE"|"DECIMAL"|"DOUBLE"|"LONG"|"STRING"|"BINARY",
          BooleanColumnStatisticsData = list(
            NumberOfTrues = 123,
            NumberOfFalses = 123,
            NumberOfNulls = 123
          ),
          DateColumnStatisticsData = list(
            MinimumValue = as.POSIXct(
              "2015-01-01"
            ),
            MaximumValue = as.POSIXct(
              "2015-01-01"
            ),
            NumberOfNulls = 123,
            NumberOfDistinctValues = 123
          ),
          DecimalColumnStatisticsData = list(
            MinimumValue = list(
              UnscaledValue = raw,
              Scale = 123
            ),
            MaximumValue = list(
              UnscaledValue = raw,
              Scale = 123
            ),
            NumberOfNulls = 123,
            NumberOfDistinctValues = 123
          ),
          DoubleColumnStatisticsData = list(
            MinimumValue = 123.0,
            MaximumValue = 123.0,
            NumberOfNulls = 123,
            NumberOfDistinctValues = 123
          ),
          LongColumnStatisticsData = list(
            MinimumValue = 123,
            MaximumValue = 123,
            NumberOfNulls = 123,
            NumberOfDistinctValues = 123
          ),
          StringColumnStatisticsData = list(
            MaximumLength = 123,
            AverageLength = 123.0,
            NumberOfNulls = 123,
            NumberOfDistinctValues = 123
          ),
          BinaryColumnStatisticsData = list(
            MaximumLength = 123,
            AverageLength = 123.0,
            NumberOfNulls = 123
          )
        )
      ),
      Error = list(
        ErrorCode = "string",
        ErrorMessage = "string"
      )
    )
  )
)
}
}
\description{
Creates or updates table statistics of columns.

The Identity and Access Management (IAM) permission required for this
operation is \code{\link[=glue_update_table]{update_table}}.
}
\section{Request syntax}{
\preformatted{svc$update_column_statistics_for_table(
  CatalogId = "string",
  DatabaseName = "string",
  TableName = "string",
  ColumnStatisticsList = list(
    list(
      ColumnName = "string",
      ColumnType = "string",
      AnalyzedTime = as.POSIXct(
        "2015-01-01"
      ),
      StatisticsData = list(
        Type = "BOOLEAN"|"DATE"|"DECIMAL"|"DOUBLE"|"LONG"|"STRING"|"BINARY",
        BooleanColumnStatisticsData = list(
          NumberOfTrues = 123,
          NumberOfFalses = 123,
          NumberOfNulls = 123
        ),
        DateColumnStatisticsData = list(
          MinimumValue = as.POSIXct(
            "2015-01-01"
          ),
          MaximumValue = as.POSIXct(
            "2015-01-01"
          ),
          NumberOfNulls = 123,
          NumberOfDistinctValues = 123
        ),
        DecimalColumnStatisticsData = list(
          MinimumValue = list(
            UnscaledValue = raw,
            Scale = 123
          ),
          MaximumValue = list(
            UnscaledValue = raw,
            Scale = 123
          ),
          NumberOfNulls = 123,
          NumberOfDistinctValues = 123
        ),
        DoubleColumnStatisticsData = list(
          MinimumValue = 123.0,
          MaximumValue = 123.0,
          NumberOfNulls = 123,
          NumberOfDistinctValues = 123
        ),
        LongColumnStatisticsData = list(
          MinimumValue = 123,
          MaximumValue = 123,
          NumberOfNulls = 123,
          NumberOfDistinctValues = 123
        ),
        StringColumnStatisticsData = list(
          MaximumLength = 123,
          AverageLength = 123.0,
          NumberOfNulls = 123,
          NumberOfDistinctValues = 123
        ),
        BinaryColumnStatisticsData = list(
          MaximumLength = 123,
          AverageLength = 123.0,
          NumberOfNulls = 123
        )
      )
    )
  )
)
}
}

\keyword{internal}
