% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_describe_configuration}
\alias{kafka_describe_configuration}
\title{Returns a description of this MSK configuration}
\usage{
kafka_describe_configuration(Arn)
}
\arguments{
\item{Arn}{[required] The Amazon Resource Name (ARN) that uniquely identifies an MSK
configuration and all of its revisions.}
}
\value{
A list with the following syntax:\preformatted{list(
  Arn = "string",
  CreationTime = as.POSIXct(
    "2015-01-01"
  ),
  Description = "string",
  KafkaVersions = list(
    "string"
  ),
  LatestRevision = list(
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    Description = "string",
    Revision = 123
  ),
  Name = "string",
  State = "ACTIVE"|"DELETING"|"DELETE_FAILED"
)
}
}
\description{
Returns a description of this MSK configuration.
}
\section{Request syntax}{
\preformatted{svc$describe_configuration(
  Arn = "string"
)
}
}

\keyword{internal}
