% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_list_workers_with_qualification_type}
\alias{mturk_list_workers_with_qualification_type}
\title{The ListWorkersWithQualificationType operation returns all of the
Workers that have been associated with a given Qualification type}
\usage{
mturk_list_workers_with_qualification_type(QualificationTypeId, Status,
  NextToken, MaxResults)
}
\arguments{
\item{QualificationTypeId}{[required] The ID of the Qualification type of the Qualifications to return.}

\item{Status}{The status of the Qualifications to return. Can be \code{Granted | Revoked}.}

\item{NextToken}{Pagination Token}

\item{MaxResults}{Limit the number of results returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  NumResults = 123,
  Qualifications = list(
    list(
      QualificationTypeId = "string",
      WorkerId = "string",
      GrantTime = as.POSIXct(
        "2015-01-01"
      ),
      IntegerValue = 123,
      LocaleValue = list(
        Country = "string",
        Subdivision = "string"
      ),
      Status = "Granted"|"Revoked"
    )
  )
)
}
}
\description{
The
\code{\link[=mturk_list_workers_with_qualification_type]{list_workers_with_qualification_type}}
operation returns all of the Workers that have been associated with a
given Qualification type.
}
\section{Request syntax}{
\preformatted{svc$list_workers_with_qualification_type(
  QualificationTypeId = "string",
  Status = "Granted"|"Revoked",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
