% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_send_bonus}
\alias{mturk_send_bonus}
\title{The SendBonus operation issues a payment of money from your account to a
Worker}
\usage{
mturk_send_bonus(WorkerId, BonusAmount, AssignmentId, Reason,
  UniqueRequestToken)
}
\arguments{
\item{WorkerId}{[required] The ID of the Worker being paid the bonus.}

\item{BonusAmount}{[required] The Bonus amount is a US Dollar amount specified using a string (for
example, "5" represents $5.00 USD and "101.42" represents $101.42 USD).
Do not include currency symbols or currency codes.}

\item{AssignmentId}{[required] The ID of the assignment for which this bonus is paid.}

\item{Reason}{[required] A message that explains the reason for the bonus payment. The Worker
receiving the bonus can see this message.}

\item{UniqueRequestToken}{A unique identifier for this request, which allows you to retry the call
on error without granting multiple bonuses. This is useful in cases such
as network timeouts where it is unclear whether or not the call
succeeded on the server. If the bonus already exists in the system from
a previous call using the same UniqueRequestToken, subsequent calls will
return an error with a message containing the request ID.}
}
\value{
An empty list.
}
\description{
The \code{\link[=mturk_send_bonus]{send_bonus}} operation issues a payment of money
from your account to a Worker. This payment happens separately from the
reward you pay to the Worker when you approve the Worker's assignment.
The SendBonus operation requires the Worker's ID and the assignment ID
as parameters to initiate payment of the bonus. You must include a
message that explains the reason for the bonus payment, as the Worker
may not be expecting the payment. Amazon Mechanical Turk collects a fee
for bonus payments, similar to the HIT listing fee. This operation fails
if your account does not have enough funds to pay for both the bonus and
the fees.
}
\section{Request syntax}{
\preformatted{svc$send_bonus(
  WorkerId = "string",
  BonusAmount = "string",
  AssignmentId = "string",
  Reason = "string",
  UniqueRequestToken = "string"
)
}
}

\keyword{internal}
