% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_group}
\alias{quicksight_create_group}
\title{Creates an Amazon QuickSight group}
\usage{
quicksight_create_group(GroupName, Description, AwsAccountId, Namespace)
}
\arguments{
\item{GroupName}{[required] A name for the group that you want to create.}

\item{Description}{A description for the group that you want to create.}

\item{AwsAccountId}{[required] The ID for the AWS account that the group is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Group = list(
    Arn = "string",
    GroupName = "string",
    Description = "string",
    PrincipalId = "string"
  ),
  RequestId = "string",
  Status = 123
)
}
}
\description{
Creates an Amazon QuickSight group.

The permissions resource is
\verb{arn:aws:quicksight:us-east-1:<relevant-aws-account-id>:group/default/<group-name> }.

The response is a group object.
}
\section{Request syntax}{
\preformatted{svc$create_group(
  GroupName = "string",
  Description = "string",
  AwsAccountId = "string",
  Namespace = "string"
)
}
}

\keyword{internal}
