% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_describe_template}
\alias{quicksight_describe_template}
\title{Describes a template's metadata}
\usage{
quicksight_describe_template(AwsAccountId, TemplateId, VersionNumber,
  AliasName)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account that contains the template that you're
describing.}

\item{TemplateId}{[required] The ID for the template.}

\item{VersionNumber}{(Optional) The number for the version to describe. If a \code{VersionNumber}
parameter value isn't provided, the latest version of the template is
described.}

\item{AliasName}{The alias of the template that you want to describe. If you name a
specific alias, you describe the version that the alias points to. You
can specify the latest version of the template by providing the keyword
\verb{$LATEST} in the \code{AliasName} parameter. The keyword \verb{$PUBLISHED} doesn't
apply to templates.}
}
\value{
A list with the following syntax:\preformatted{list(
  Template = list(
    Arn = "string",
    Name = "string",
    Version = list(
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      Errors = list(
        list(
          Type = "SOURCE_NOT_FOUND"|"DATA_SET_NOT_FOUND"|"INTERNAL_FAILURE"|"ACCESS_DENIED",
          Message = "string"
        )
      ),
      VersionNumber = 123,
      Status = "CREATION_IN_PROGRESS"|"CREATION_SUCCESSFUL"|"CREATION_FAILED"|"UPDATE_IN_PROGRESS"|"UPDATE_SUCCESSFUL"|"UPDATE_FAILED"|"DELETED",
      DataSetConfigurations = list(
        list(
          Placeholder = "string",
          DataSetSchema = list(
            ColumnSchemaList = list(
              list(
                Name = "string",
                DataType = "string",
                GeographicRole = "string"
              )
            )
          ),
          ColumnGroupSchemaList = list(
            list(
              Name = "string",
              ColumnGroupColumnSchemaList = list(
                list(
                  Name = "string"
                )
              )
            )
          )
        )
      ),
      Description = "string",
      SourceEntityArn = "string",
      ThemeArn = "string",
      Sheets = list(
        list(
          SheetId = "string",
          Name = "string"
        )
      )
    ),
    TemplateId = "string",
    LastUpdatedTime = as.POSIXct(
      "2015-01-01"
    ),
    CreatedTime = as.POSIXct(
      "2015-01-01"
    )
  ),
  Status = 123,
  RequestId = "string"
)
}
}
\description{
Describes a template's metadata.
}
\section{Request syntax}{
\preformatted{svc$describe_template(
  AwsAccountId = "string",
  TemplateId = "string",
  VersionNumber = 123,
  AliasName = "string"
)
}
}

\keyword{internal}
