# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include datapipeline_service.R
NULL

#' Validates the specified pipeline and starts processing pipeline tasks
#'
#' Validates the specified pipeline and starts processing pipeline tasks.
#' If the pipeline does not pass validation, activation fails.
#' 
#' If you need to pause the pipeline to investigate an issue with a
#' component, such as a data source or script, call DeactivatePipeline.
#' 
#' To activate a finished pipeline, modify the end date for the pipeline
#' and then activate it.
#'
#' @usage
#' datapipeline_activate_pipeline(pipelineId, parameterValues,
#'   startTimestamp)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#' @param parameterValues A list of parameter values to pass to the pipeline at activation.
#' @param startTimestamp The date and time to resume the pipeline. By default, the pipeline
#' resumes from the last completed execution.
#'
#' @section Request syntax:
#' ```
#' svc$activate_pipeline(
#'   pipelineId = "string",
#'   parameterValues = list(
#'     list(
#'       id = "string",
#'       stringValue = "string"
#'     )
#'   ),
#'   startTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_activate_pipeline
datapipeline_activate_pipeline <- function(pipelineId, parameterValues = NULL, startTimestamp = NULL) {
  op <- new_operation(
    name = "ActivatePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$activate_pipeline_input(pipelineId = pipelineId, parameterValues = parameterValues, startTimestamp = startTimestamp)
  output <- .datapipeline$activate_pipeline_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$activate_pipeline <- datapipeline_activate_pipeline

#' Adds or modifies tags for the specified pipeline
#'
#' Adds or modifies tags for the specified pipeline.
#'
#' @usage
#' datapipeline_add_tags(pipelineId, tags)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#' @param tags &#91;required&#93; The tags to add, as key/value pairs.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags(
#'   pipelineId = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_add_tags
datapipeline_add_tags <- function(pipelineId, tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$add_tags_input(pipelineId = pipelineId, tags = tags)
  output <- .datapipeline$add_tags_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$add_tags <- datapipeline_add_tags

#' Creates a new, empty pipeline
#'
#' Creates a new, empty pipeline. Use PutPipelineDefinition to populate the
#' pipeline.
#'
#' @usage
#' datapipeline_create_pipeline(name, uniqueId, description, tags)
#'
#' @param name &#91;required&#93; The name for the pipeline. You can use the same name for multiple
#' pipelines associated with your AWS account, because AWS Data Pipeline
#' assigns each pipeline a unique pipeline identifier.
#' @param uniqueId &#91;required&#93; A unique identifier. This identifier is not the same as the pipeline
#' identifier assigned by AWS Data Pipeline. You are responsible for
#' defining the format and ensuring the uniqueness of this identifier. You
#' use this parameter to ensure idempotency during repeated calls to
#' `CreatePipeline`. For example, if the first call to `CreatePipeline`
#' does not succeed, you can pass in the same unique identifier and
#' pipeline name combination on a subsequent call to `CreatePipeline`.
#' `CreatePipeline` ensures that if a pipeline already exists with the same
#' name and unique identifier, a new pipeline is not created. Instead,
#' you\'ll receive the pipeline identifier from the previous attempt. The
#' uniqueness of the name and unique identifier combination is scoped to
#' the AWS account or IAM user credentials.
#' @param description The description for the pipeline.
#' @param tags A list of tags to associate with the pipeline at creation. Tags let you
#' control access to pipelines. For more information, see [Controlling User
#' Access to
#' Pipelines](http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html)
#' in the *AWS Data Pipeline Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_pipeline(
#'   name = "string",
#'   uniqueId = "string",
#'   description = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_create_pipeline
datapipeline_create_pipeline <- function(name, uniqueId, description = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreatePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$create_pipeline_input(name = name, uniqueId = uniqueId, description = description, tags = tags)
  output <- .datapipeline$create_pipeline_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$create_pipeline <- datapipeline_create_pipeline

#' Deactivates the specified running pipeline
#'
#' Deactivates the specified running pipeline. The pipeline is set to the
#' `DEACTIVATING` state until the deactivation process completes.
#' 
#' To resume a deactivated pipeline, use ActivatePipeline. By default, the
#' pipeline resumes from the last completed execution. Optionally, you can
#' specify the date and time to resume the pipeline.
#'
#' @usage
#' datapipeline_deactivate_pipeline(pipelineId, cancelActive)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#' @param cancelActive Indicates whether to cancel any running objects. The default is true,
#' which sets the state of any running objects to `CANCELED`. If this value
#' is false, the pipeline is deactivated after all running objects finish.
#'
#' @section Request syntax:
#' ```
#' svc$deactivate_pipeline(
#'   pipelineId = "string",
#'   cancelActive = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_deactivate_pipeline
datapipeline_deactivate_pipeline <- function(pipelineId, cancelActive = NULL) {
  op <- new_operation(
    name = "DeactivatePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$deactivate_pipeline_input(pipelineId = pipelineId, cancelActive = cancelActive)
  output <- .datapipeline$deactivate_pipeline_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$deactivate_pipeline <- datapipeline_deactivate_pipeline

#' Deletes a pipeline, its pipeline definition, and its run history
#'
#' Deletes a pipeline, its pipeline definition, and its run history. AWS
#' Data Pipeline attempts to cancel instances associated with the pipeline
#' that are currently being processed by task runners.
#' 
#' Deleting a pipeline cannot be undone. You cannot query or restore a
#' deleted pipeline. To temporarily pause a pipeline instead of deleting
#' it, call SetStatus with the status set to `PAUSE` on individual
#' components. Components that are paused by SetStatus can be resumed.
#'
#' @usage
#' datapipeline_delete_pipeline(pipelineId)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#'
#' @section Request syntax:
#' ```
#' svc$delete_pipeline(
#'   pipelineId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_delete_pipeline
datapipeline_delete_pipeline <- function(pipelineId) {
  op <- new_operation(
    name = "DeletePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$delete_pipeline_input(pipelineId = pipelineId)
  output <- .datapipeline$delete_pipeline_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$delete_pipeline <- datapipeline_delete_pipeline

#' Gets the object definitions for a set of objects associated with the
#' pipeline
#'
#' Gets the object definitions for a set of objects associated with the
#' pipeline. Object definitions are composed of a set of fields that define
#' the properties of the object.
#'
#' @usage
#' datapipeline_describe_objects(pipelineId, objectIds,
#'   evaluateExpressions, marker)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline that contains the object definitions.
#' @param objectIds &#91;required&#93; The IDs of the pipeline objects that contain the definitions to be
#' described. You can pass as many as 25 identifiers in a single call to
#' `DescribeObjects`.
#' @param evaluateExpressions Indicates whether any expressions in the object should be evaluated when
#' the object descriptions are returned.
#' @param marker The starting point for the results to be returned. For the first call,
#' this value should be empty. As long as there are more results, continue
#' to call `DescribeObjects` with the marker value from the previous call
#' to retrieve the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_objects(
#'   pipelineId = "string",
#'   objectIds = list(
#'     "string"
#'   ),
#'   evaluateExpressions = TRUE|FALSE,
#'   marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_describe_objects
datapipeline_describe_objects <- function(pipelineId, objectIds, evaluateExpressions = NULL, marker = NULL) {
  op <- new_operation(
    name = "DescribeObjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$describe_objects_input(pipelineId = pipelineId, objectIds = objectIds, evaluateExpressions = evaluateExpressions, marker = marker)
  output <- .datapipeline$describe_objects_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$describe_objects <- datapipeline_describe_objects

#' Retrieves metadata about one or more pipelines
#'
#' Retrieves metadata about one or more pipelines. The information
#' retrieved includes the name of the pipeline, the pipeline identifier,
#' its current state, and the user account that owns the pipeline. Using
#' account credentials, you can retrieve metadata about pipelines that you
#' or your IAM users have created. If you are using an IAM user account,
#' you can retrieve metadata about only those pipelines for which you have
#' read permissions.
#' 
#' To retrieve the full pipeline definition instead of metadata about the
#' pipeline, call GetPipelineDefinition.
#'
#' @usage
#' datapipeline_describe_pipelines(pipelineIds)
#'
#' @param pipelineIds &#91;required&#93; The IDs of the pipelines to describe. You can pass as many as 25
#' identifiers in a single call. To obtain pipeline IDs, call
#' ListPipelines.
#'
#' @section Request syntax:
#' ```
#' svc$describe_pipelines(
#'   pipelineIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_describe_pipelines
datapipeline_describe_pipelines <- function(pipelineIds) {
  op <- new_operation(
    name = "DescribePipelines",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$describe_pipelines_input(pipelineIds = pipelineIds)
  output <- .datapipeline$describe_pipelines_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$describe_pipelines <- datapipeline_describe_pipelines

#' Task runners call EvaluateExpression to evaluate a string in the context
#' of the specified object
#'
#' Task runners call `EvaluateExpression` to evaluate a string in the
#' context of the specified object. For example, a task runner can evaluate
#' SQL queries stored in Amazon S3.
#'
#' @usage
#' datapipeline_evaluate_expression(pipelineId, objectId, expression)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#' @param objectId &#91;required&#93; The ID of the object.
#' @param expression &#91;required&#93; The expression to evaluate.
#'
#' @section Request syntax:
#' ```
#' svc$evaluate_expression(
#'   pipelineId = "string",
#'   objectId = "string",
#'   expression = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_evaluate_expression
datapipeline_evaluate_expression <- function(pipelineId, objectId, expression) {
  op <- new_operation(
    name = "EvaluateExpression",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$evaluate_expression_input(pipelineId = pipelineId, objectId = objectId, expression = expression)
  output <- .datapipeline$evaluate_expression_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$evaluate_expression <- datapipeline_evaluate_expression

#' Gets the definition of the specified pipeline
#'
#' Gets the definition of the specified pipeline. You can call
#' `GetPipelineDefinition` to retrieve the pipeline definition that you
#' provided using PutPipelineDefinition.
#'
#' @usage
#' datapipeline_get_pipeline_definition(pipelineId, version)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#' @param version The version of the pipeline definition to retrieve. Set this parameter
#' to `latest` (default) to use the last definition saved to the pipeline
#' or `active` to use the last definition that was activated.
#'
#' @section Request syntax:
#' ```
#' svc$get_pipeline_definition(
#'   pipelineId = "string",
#'   version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_get_pipeline_definition
datapipeline_get_pipeline_definition <- function(pipelineId, version = NULL) {
  op <- new_operation(
    name = "GetPipelineDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$get_pipeline_definition_input(pipelineId = pipelineId, version = version)
  output <- .datapipeline$get_pipeline_definition_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$get_pipeline_definition <- datapipeline_get_pipeline_definition

#' Lists the pipeline identifiers for all active pipelines that you have
#' permission to access
#'
#' Lists the pipeline identifiers for all active pipelines that you have
#' permission to access.
#'
#' @usage
#' datapipeline_list_pipelines(marker)
#'
#' @param marker The starting point for the results to be returned. For the first call,
#' this value should be empty. As long as there are more results, continue
#' to call `ListPipelines` with the marker value from the previous call to
#' retrieve the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_pipelines(
#'   marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_list_pipelines
datapipeline_list_pipelines <- function(marker = NULL) {
  op <- new_operation(
    name = "ListPipelines",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$list_pipelines_input(marker = marker)
  output <- .datapipeline$list_pipelines_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$list_pipelines <- datapipeline_list_pipelines

#' Task runners call PollForTask to receive a task to perform from AWS Data
#' Pipeline
#'
#' Task runners call `PollForTask` to receive a task to perform from AWS
#' Data Pipeline. The task runner specifies which tasks it can perform by
#' setting a value for the `workerGroup` parameter. The task returned can
#' come from any of the pipelines that match the `workerGroup` value passed
#' in by the task runner and that was launched using the IAM user
#' credentials specified by the task runner.
#' 
#' If tasks are ready in the work queue, `PollForTask` returns a response
#' immediately. If no tasks are available in the queue, `PollForTask` uses
#' long-polling and holds on to a poll connection for up to a 90 seconds,
#' during which time the first newly scheduled task is handed to the task
#' runner. To accomodate this, set the socket timeout in your task runner
#' to 90 seconds. The task runner should not call `PollForTask` again on
#' the same `workerGroup` until it receives a response, and this can take
#' up to 90 seconds.
#'
#' @usage
#' datapipeline_poll_for_task(workerGroup, hostname, instanceIdentity)
#'
#' @param workerGroup &#91;required&#93; The type of task the task runner is configured to accept and process.
#' The worker group is set as a field on objects in the pipeline when they
#' are created. You can only specify a single value for `workerGroup` in
#' the call to `PollForTask`. There are no wildcard values permitted in
#' `workerGroup`; the string must be an exact, case-sensitive, match.
#' @param hostname The public DNS name of the calling task runner.
#' @param instanceIdentity Identity information for the EC2 instance that is hosting the task
#' runner. You can get this value from the instance using
#' `http://169.254.169.254/latest/meta-data/instance-id`. For more
#' information, see [Instance
#' Metadata](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html)
#' in the *Amazon Elastic Compute Cloud User Guide.* Passing in this value
#' proves that your task runner is running on an EC2 instance, and ensures
#' the proper AWS Data Pipeline service charges are applied to your
#' pipeline.
#'
#' @section Request syntax:
#' ```
#' svc$poll_for_task(
#'   workerGroup = "string",
#'   hostname = "string",
#'   instanceIdentity = list(
#'     document = "string",
#'     signature = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_poll_for_task
datapipeline_poll_for_task <- function(workerGroup, hostname = NULL, instanceIdentity = NULL) {
  op <- new_operation(
    name = "PollForTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$poll_for_task_input(workerGroup = workerGroup, hostname = hostname, instanceIdentity = instanceIdentity)
  output <- .datapipeline$poll_for_task_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$poll_for_task <- datapipeline_poll_for_task

#' Adds tasks, schedules, and preconditions to the specified pipeline
#'
#' Adds tasks, schedules, and preconditions to the specified pipeline. You
#' can use `PutPipelineDefinition` to populate a new pipeline.
#' 
#' `PutPipelineDefinition` also validates the configuration as it adds it
#' to the pipeline. Changes to the pipeline are saved unless one of the
#' following three validation errors exists in the pipeline.
#' 
#' 1.  An object is missing a name or identifier field.
#' 2.  A string or reference field is empty.
#' 3.  The number of objects in the pipeline exceeds the maximum allowed
#'     objects.
#' 4.  The pipeline is in a FINISHED state.
#' 
#' Pipeline object definitions are passed to the `PutPipelineDefinition`
#' action and returned by the GetPipelineDefinition action.
#'
#' @usage
#' datapipeline_put_pipeline_definition(pipelineId, pipelineObjects,
#'   parameterObjects, parameterValues)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#' @param pipelineObjects &#91;required&#93; The objects that define the pipeline. These objects overwrite the
#' existing pipeline definition.
#' @param parameterObjects The parameter objects used with the pipeline.
#' @param parameterValues The parameter values used with the pipeline.
#'
#' @section Request syntax:
#' ```
#' svc$put_pipeline_definition(
#'   pipelineId = "string",
#'   pipelineObjects = list(
#'     list(
#'       id = "string",
#'       name = "string",
#'       fields = list(
#'         list(
#'           key = "string",
#'           stringValue = "string",
#'           refValue = "string"
#'         )
#'       )
#'     )
#'   ),
#'   parameterObjects = list(
#'     list(
#'       id = "string",
#'       attributes = list(
#'         list(
#'           key = "string",
#'           stringValue = "string"
#'         )
#'       )
#'     )
#'   ),
#'   parameterValues = list(
#'     list(
#'       id = "string",
#'       stringValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_put_pipeline_definition
datapipeline_put_pipeline_definition <- function(pipelineId, pipelineObjects, parameterObjects = NULL, parameterValues = NULL) {
  op <- new_operation(
    name = "PutPipelineDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$put_pipeline_definition_input(pipelineId = pipelineId, pipelineObjects = pipelineObjects, parameterObjects = parameterObjects, parameterValues = parameterValues)
  output <- .datapipeline$put_pipeline_definition_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$put_pipeline_definition <- datapipeline_put_pipeline_definition

#' Queries the specified pipeline for the names of objects that match the
#' specified set of conditions
#'
#' Queries the specified pipeline for the names of objects that match the
#' specified set of conditions.
#'
#' @usage
#' datapipeline_query_objects(pipelineId, query, sphere, marker, limit)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#' @param query The query that defines the objects to be returned. The `Query` object
#' can contain a maximum of ten selectors. The conditions in the query are
#' limited to top-level String fields in the object. These filters can be
#' applied to components, instances, and attempts.
#' @param sphere &#91;required&#93; Indicates whether the query applies to components or instances. The
#' possible values are: `COMPONENT`, `INSTANCE`, and `ATTEMPT`.
#' @param marker The starting point for the results to be returned. For the first call,
#' this value should be empty. As long as there are more results, continue
#' to call `QueryObjects` with the marker value from the previous call to
#' retrieve the next set of results.
#' @param limit The maximum number of object names that `QueryObjects` will return in a
#' single call. The default value is 100.
#'
#' @section Request syntax:
#' ```
#' svc$query_objects(
#'   pipelineId = "string",
#'   query = list(
#'     selectors = list(
#'       list(
#'         fieldName = "string",
#'         operator = list(
#'           type = "EQ"|"REF_EQ"|"LE"|"GE"|"BETWEEN",
#'           values = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   sphere = "string",
#'   marker = "string",
#'   limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_query_objects
datapipeline_query_objects <- function(pipelineId, query = NULL, sphere, marker = NULL, limit = NULL) {
  op <- new_operation(
    name = "QueryObjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$query_objects_input(pipelineId = pipelineId, query = query, sphere = sphere, marker = marker, limit = limit)
  output <- .datapipeline$query_objects_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$query_objects <- datapipeline_query_objects

#' Removes existing tags from the specified pipeline
#'
#' Removes existing tags from the specified pipeline.
#'
#' @usage
#' datapipeline_remove_tags(pipelineId, tagKeys)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#' @param tagKeys &#91;required&#93; The keys of the tags to remove.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags(
#'   pipelineId = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_remove_tags
datapipeline_remove_tags <- function(pipelineId, tagKeys) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$remove_tags_input(pipelineId = pipelineId, tagKeys = tagKeys)
  output <- .datapipeline$remove_tags_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$remove_tags <- datapipeline_remove_tags

#' Task runners call ReportTaskProgress when assigned a task to acknowledge
#' that it has the task
#'
#' Task runners call `ReportTaskProgress` when assigned a task to
#' acknowledge that it has the task. If the web service does not receive
#' this acknowledgement within 2 minutes, it assigns the task in a
#' subsequent PollForTask call. After this initial acknowledgement, the
#' task runner only needs to report progress every 15 minutes to maintain
#' its ownership of the task. You can change this reporting time from 15
#' minutes by specifying a `reportProgressTimeout` field in your pipeline.
#' 
#' If a task runner does not report its status after 5 minutes, AWS Data
#' Pipeline assumes that the task runner is unable to process the task and
#' reassigns the task in a subsequent response to PollForTask. Task runners
#' should call `ReportTaskProgress` every 60 seconds.
#'
#' @usage
#' datapipeline_report_task_progress(taskId, fields)
#'
#' @param taskId &#91;required&#93; The ID of the task assigned to the task runner. This value is provided
#' in the response for PollForTask.
#' @param fields Key-value pairs that define the properties of the
#' ReportTaskProgressInput object.
#'
#' @section Request syntax:
#' ```
#' svc$report_task_progress(
#'   taskId = "string",
#'   fields = list(
#'     list(
#'       key = "string",
#'       stringValue = "string",
#'       refValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_report_task_progress
datapipeline_report_task_progress <- function(taskId, fields = NULL) {
  op <- new_operation(
    name = "ReportTaskProgress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$report_task_progress_input(taskId = taskId, fields = fields)
  output <- .datapipeline$report_task_progress_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$report_task_progress <- datapipeline_report_task_progress

#' Task runners call ReportTaskRunnerHeartbeat every 15 minutes to indicate
#' that they are operational
#'
#' Task runners call `ReportTaskRunnerHeartbeat` every 15 minutes to
#' indicate that they are operational. If the AWS Data Pipeline Task Runner
#' is launched on a resource managed by AWS Data Pipeline, the web service
#' can use this call to detect when the task runner application has failed
#' and restart a new instance.
#'
#' @usage
#' datapipeline_report_task_runner_heartbeat(taskrunnerId, workerGroup,
#'   hostname)
#'
#' @param taskrunnerId &#91;required&#93; The ID of the task runner. This value should be unique across your AWS
#' account. In the case of AWS Data Pipeline Task Runner launched on a
#' resource managed by AWS Data Pipeline, the web service provides a unique
#' identifier when it launches the application. If you have written a
#' custom task runner, you should assign a unique identifier for the task
#' runner.
#' @param workerGroup The type of task the task runner is configured to accept and process.
#' The worker group is set as a field on objects in the pipeline when they
#' are created. You can only specify a single value for `workerGroup`.
#' There are no wildcard values permitted in `workerGroup`; the string must
#' be an exact, case-sensitive, match.
#' @param hostname The public DNS name of the task runner.
#'
#' @section Request syntax:
#' ```
#' svc$report_task_runner_heartbeat(
#'   taskrunnerId = "string",
#'   workerGroup = "string",
#'   hostname = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_report_task_runner_heartbeat
datapipeline_report_task_runner_heartbeat <- function(taskrunnerId, workerGroup = NULL, hostname = NULL) {
  op <- new_operation(
    name = "ReportTaskRunnerHeartbeat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$report_task_runner_heartbeat_input(taskrunnerId = taskrunnerId, workerGroup = workerGroup, hostname = hostname)
  output <- .datapipeline$report_task_runner_heartbeat_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$report_task_runner_heartbeat <- datapipeline_report_task_runner_heartbeat

#' Requests that the status of the specified physical or logical pipeline
#' objects be updated in the specified pipeline
#'
#' Requests that the status of the specified physical or logical pipeline
#' objects be updated in the specified pipeline. This update might not
#' occur immediately, but is eventually consistent. The status that can be
#' set depends on the type of object (for example, DataNode or Activity).
#' You cannot perform this operation on `FINISHED` pipelines and attempting
#' to do so returns `InvalidRequestException`.
#'
#' @usage
#' datapipeline_set_status(pipelineId, objectIds, status)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline that contains the objects.
#' @param objectIds &#91;required&#93; The IDs of the objects. The corresponding objects can be either physical
#' or components, but not a mix of both types.
#' @param status &#91;required&#93; The status to be set on all the objects specified in `objectIds`. For
#' components, use `PAUSE` or `RESUME`. For instances, use `TRY_CANCEL`,
#' `RERUN`, or `MARK_FINISHED`.
#'
#' @section Request syntax:
#' ```
#' svc$set_status(
#'   pipelineId = "string",
#'   objectIds = list(
#'     "string"
#'   ),
#'   status = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_set_status
datapipeline_set_status <- function(pipelineId, objectIds, status) {
  op <- new_operation(
    name = "SetStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$set_status_input(pipelineId = pipelineId, objectIds = objectIds, status = status)
  output <- .datapipeline$set_status_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$set_status <- datapipeline_set_status

#' Task runners call SetTaskStatus to notify AWS Data Pipeline that a task
#' is completed and provide information about the final status
#'
#' Task runners call `SetTaskStatus` to notify AWS Data Pipeline that a
#' task is completed and provide information about the final status. A task
#' runner makes this call regardless of whether the task was sucessful. A
#' task runner does not need to call `SetTaskStatus` for tasks that are
#' canceled by the web service during a call to ReportTaskProgress.
#'
#' @usage
#' datapipeline_set_task_status(taskId, taskStatus, errorId, errorMessage,
#'   errorStackTrace)
#'
#' @param taskId &#91;required&#93; The ID of the task assigned to the task runner. This value is provided
#' in the response for PollForTask.
#' @param taskStatus &#91;required&#93; If `FINISHED`, the task successfully completed. If `FAILED`, the task
#' ended unsuccessfully. Preconditions use false.
#' @param errorId If an error occurred during the task, this value specifies the error
#' code. This value is set on the physical attempt object. It is used to
#' display error information to the user. It should not start with string
#' \"Service\\_\" which is reserved by the system.
#' @param errorMessage If an error occurred during the task, this value specifies a text
#' description of the error. This value is set on the physical attempt
#' object. It is used to display error information to the user. The web
#' service does not parse this value.
#' @param errorStackTrace If an error occurred during the task, this value specifies the stack
#' trace associated with the error. This value is set on the physical
#' attempt object. It is used to display error information to the user. The
#' web service does not parse this value.
#'
#' @section Request syntax:
#' ```
#' svc$set_task_status(
#'   taskId = "string",
#'   taskStatus = "FINISHED"|"FAILED"|"FALSE",
#'   errorId = "string",
#'   errorMessage = "string",
#'   errorStackTrace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_set_task_status
datapipeline_set_task_status <- function(taskId, taskStatus, errorId = NULL, errorMessage = NULL, errorStackTrace = NULL) {
  op <- new_operation(
    name = "SetTaskStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$set_task_status_input(taskId = taskId, taskStatus = taskStatus, errorId = errorId, errorMessage = errorMessage, errorStackTrace = errorStackTrace)
  output <- .datapipeline$set_task_status_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$set_task_status <- datapipeline_set_task_status

#' Validates the specified pipeline definition to ensure that it is well
#' formed and can be run without error
#'
#' Validates the specified pipeline definition to ensure that it is well
#' formed and can be run without error.
#'
#' @usage
#' datapipeline_validate_pipeline_definition(pipelineId, pipelineObjects,
#'   parameterObjects, parameterValues)
#'
#' @param pipelineId &#91;required&#93; The ID of the pipeline.
#' @param pipelineObjects &#91;required&#93; The objects that define the pipeline changes to validate against the
#' pipeline.
#' @param parameterObjects The parameter objects used with the pipeline.
#' @param parameterValues The parameter values used with the pipeline.
#'
#' @section Request syntax:
#' ```
#' svc$validate_pipeline_definition(
#'   pipelineId = "string",
#'   pipelineObjects = list(
#'     list(
#'       id = "string",
#'       name = "string",
#'       fields = list(
#'         list(
#'           key = "string",
#'           stringValue = "string",
#'           refValue = "string"
#'         )
#'       )
#'     )
#'   ),
#'   parameterObjects = list(
#'     list(
#'       id = "string",
#'       attributes = list(
#'         list(
#'           key = "string",
#'           stringValue = "string"
#'         )
#'       )
#'     )
#'   ),
#'   parameterValues = list(
#'     list(
#'       id = "string",
#'       stringValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname datapipeline_validate_pipeline_definition
datapipeline_validate_pipeline_definition <- function(pipelineId, pipelineObjects, parameterObjects = NULL, parameterValues = NULL) {
  op <- new_operation(
    name = "ValidatePipelineDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .datapipeline$validate_pipeline_definition_input(pipelineId = pipelineId, pipelineObjects = pipelineObjects, parameterObjects = parameterObjects, parameterValues = parameterValues)
  output <- .datapipeline$validate_pipeline_definition_output()
  svc <- .datapipeline$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datapipeline$operations$validate_pipeline_definition <- datapipeline_validate_pipeline_definition
