% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_add_job_flow_steps}
\alias{emr_add_job_flow_steps}
\title{AddJobFlowSteps adds new steps to a running cluster}
\usage{
emr_add_job_flow_steps(JobFlowId, Steps)
}
\arguments{
\item{JobFlowId}{[required] A string that uniquely identifies the job flow. This identifier is
returned by RunJobFlow and can also be obtained from ListClusters.}

\item{Steps}{[required] A list of StepConfig to be executed by the job flow.}
}
\description{
AddJobFlowSteps adds new steps to a running cluster. A maximum of 256
steps are allowed in each job flow.
}
\details{
If your cluster is long-running (such as a Hive data warehouse) or
complex, you may require more than 256 steps to process your data. You
can bypass the 256-step limitation in various ways, including using SSH
to connect to the master node and submitting queries directly to the
software running on the master node, such as Hive and Hadoop. For more
information on how to do this, see \href{https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html}{Add More than 256 Steps to a Cluster}
in the \emph{Amazon EMR Management Guide}.

A step specifies the location of a JAR file stored either on the master
node of the cluster or in Amazon S3. Each step is performed by the main
function of the main class of the JAR file. The main class can be
specified either in the manifest of the JAR or by using the MainFunction
parameter of the step.

Amazon EMR executes each step in the order listed. For a step to be
considered complete, the main function must exit with a zero exit code
and all Hadoop jobs started while the step was running must have
completed and run successfully.

You can only add steps to a cluster that is in one of the following
states: STARTING, BOOTSTRAPPING, RUNNING, or WAITING.
}
\section{Request syntax}{
\preformatted{svc$add_job_flow_steps(
  JobFlowId = "string",
  Steps = list(
    list(
      Name = "string",
      ActionOnFailure = "TERMINATE_JOB_FLOW"|"TERMINATE_CLUSTER"|"CANCEL_AND_WAIT"|"CONTINUE",
      HadoopJarStep = list(
        Properties = list(
          list(
            Key = "string",
            Value = "string"
          )
        ),
        Jar = "string",
        MainClass = "string",
        Args = list(
          "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
